/*
 * Decompiled with CFR 0.152.
 */
package com.ella.common.configure.rocketmq;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.ella.frame.common.mq.MsgHandlerDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(MsgListener.class);
    @Autowired
    private MsgHandlerDispatcher dispatcher;

    public Action consume(Message msg, ConsumeContext ctx) {
        Action result = Action.ReconsumeLater;
        String msgContent = new String(msg.getBody());
        log.info("Receive msg [{}]", (Object)msgContent);
        try {
            if (this.dispatcher.dispatch(msgContent)) {
                result = Action.CommitMessage;
            } else {
                log.warn("Msg [{}] consume failed!", (Object)msgContent);
            }
        }
        catch (Exception e) {
            log.error("Message [{}] consume failed - {},will reconsumer later!", (Object)msgContent, (Object)e.getMessage());
            e.printStackTrace();
        }
        return result;
    }
}

