/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util.redisnew;

import com.ella.util.redisnew.DistributedCache;
import com.ella.util.redisnew.ObjectCache;
import com.ella.util.redisnew.SpringDataRedisCache;
import com.ella.util.redisnew.SpringObjectRedisCache;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import redis.clients.jedis.Jedis;

@Configuration
@ConditionalOnClass(value={JedisConnection.class, RedisOperations.class, Jedis.class})
public class RedisCacheAutoConfiguration {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Bean
    public RedisTemplate redisTemplate(RedisConnectionFactory factory) {
        StringRedisTemplate template = new StringRedisTemplate(factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean
    public ObjectCache objectCache(RedisTemplate redisTemplate) {
        SpringObjectRedisCache objectRedisCache = new SpringObjectRedisCache(redisTemplate);
        return objectRedisCache;
    }

    @Bean
    public DistributedCache redisCache() {
        SpringDataRedisCache redisCache = new SpringDataRedisCache();
        redisCache.setRedisTemplate(this.stringRedisTemplate);
        return redisCache;
    }
}

