/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util.redis;

import com.alibaba.fastjson.JSONObject;
import com.ella.util.CodeUtil;
import com.ella.util.redis.RedisZoneEnum;
import com.ella.util.redis.ThreadRedisTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class RedisServiceUtil
implements InitializingBean {
    private static final Map<Long, ThreadRedisTemplate> threadRedisTemplateMap = new HashMap<Long, ThreadRedisTemplate>();
    private static final StringRedisTemplate[] redisZoneTemplateArray = new StringRedisTemplate[16];
    private static Integer originalRedisZone = null;
    private static Long originalThreadId = null;
    @Autowired
    private StringRedisTemplate redisTemplate0;

    public void afterPropertiesSet() throws Exception {
    }

    private StringRedisTemplate createRedisZoneTemplate(RedisZoneEnum zoneEnum) throws Exception {
        StringRedisTemplate cloneRedisTemplate = (StringRedisTemplate)BeanUtils.cloneBean((Object)this.redisTemplate0);
        cloneRedisTemplate.setConnectionFactory((RedisConnectionFactory)((JedisConnectionFactory)BeanUtils.cloneBean((Object)this.redisTemplate0.getConnectionFactory())));
        cloneRedisTemplate.afterPropertiesSet();
        ((JedisConnectionFactory)cloneRedisTemplate.getConnectionFactory()).setDatabase(zoneEnum.getValue());
        StringRedisTemplate stringRedisTemplate = cloneRedisTemplate;
        RedisServiceUtil.redisZoneTemplateArray[zoneEnum.getValue()] = stringRedisTemplate;
        return stringRedisTemplate;
    }

    public StringRedisTemplate getRedisTemplate() {
        long id = Thread.currentThread().getId();
        ThreadRedisTemplate threadRedisTemplate = threadRedisTemplateMap.get(id);
        if (threadRedisTemplate == null) {
            try {
                this.setDatabase(this.getDatabase());
                threadRedisTemplate = threadRedisTemplateMap.get(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return threadRedisTemplate.getThreadRedisTemplate();
    }

    public StringRedisTemplate getRedisTemplate(RedisZoneEnum zoneEnum) throws Exception {
        int zone;
        int n = zone = zoneEnum == null ? -1 : zoneEnum.getValue();
        if (zone < 0 || zone > 15) {
            throw new Exception("error:zone=" + zone + ", redis zone value must between 0 and 15 !");
        }
        return redisZoneTemplateArray[zone] == null ? this.createRedisZoneTemplate(zoneEnum) : redisZoneTemplateArray[zone];
    }

    public int getDatabase() {
        ThreadRedisTemplate threadRedisTemplate = threadRedisTemplateMap.get(Thread.currentThread().getId());
        if (threadRedisTemplate == null) {
            try {
                this.setDatabase(originalRedisZone == null || originalRedisZone < 0 ? (originalRedisZone = Integer.valueOf(0)) : originalRedisZone);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StringRedisTemplate redisTemplate = threadRedisTemplateMap.get(Thread.currentThread().getId()).getThreadRedisTemplate();
        return ((JedisConnectionFactory)redisTemplate.getConnectionFactory()).getDatabase();
    }

    private void setDatabase(int zone) throws Exception {
        StringRedisTemplate redisTemplate = this.getRedisTemplate(RedisZoneEnum.getRedisZoneEnum(zone));
        long timeMillis = System.currentTimeMillis();
        Iterator<Map.Entry<Long, ThreadRedisTemplate>> iterator = threadRedisTemplateMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, ThreadRedisTemplate> next = iterator.next();
            Long key = next.getKey();
            if (key != null && next.getValue().getExpire() / 1000L + 300L >= timeMillis / 1000L) continue;
            iterator.remove();
        }
        ThreadRedisTemplate threadRedisTemplate = new ThreadRedisTemplate();
        threadRedisTemplate.setExpire(timeMillis);
        threadRedisTemplate.setThreadRedisTemplate(redisTemplate);
        threadRedisTemplate.setThread(Thread.currentThread());
        threadRedisTemplateMap.put(Thread.currentThread().getId(), threadRedisTemplate);
    }

    protected void setDatabase(RedisZoneEnum zoneEnum) throws Exception {
        long currentThreadId = Thread.currentThread().getId();
        if (originalThreadId == null) {
            originalThreadId = currentThreadId;
        }
        if (originalRedisZone == null && originalThreadId == currentThreadId) {
            originalRedisZone = zoneEnum.getValue();
        }
        this.setDatabase(zoneEnum == null ? -1 : zoneEnum.getValue());
    }

    @RequestMapping(value={"/set"})
    public boolean set(final String key, final String value) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        boolean result = (Boolean)redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                connection.set(serializer.serialize((Object)key), serializer.serialize((Object)value));
                return true;
            }
        });
        return result;
    }

    @RequestMapping(value={"/setEx"})
    public boolean setEx(final String key, final long expire, final String value) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        boolean result = (Boolean)redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                connection.setEx(serializer.serialize((Object)key), expire, serializer.serialize((Object)value));
                return true;
            }
        });
        return result;
    }

    @RequestMapping(value={"/setNX"})
    public boolean setNX(final String key, final String value) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        boolean result = (Boolean)redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                Boolean setNX = connection.setNX(serializer.serialize((Object)key), serializer.serialize((Object)value));
                return setNX;
            }
        });
        return result;
    }

    @RequestMapping(value={"/hSet"})
    public boolean hSet(final String key, final String filed, final String value) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        boolean result = (Boolean)redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                connection.hSet(serializer.serialize((Object)key), serializer.serialize((Object)filed), serializer.serialize((Object)value));
                return true;
            }
        });
        return result;
    }

    @RequestMapping(value={"/mSet"})
    public boolean mSet(final String map) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        boolean result = (Boolean)redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                Map map1 = (Map)JSONObject.parseObject((String)map, Map.class);
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                Map emptyMap = Collections.emptyMap();
                map1.entrySet().iterator().forEachRemaining(m -> {
                    byte[] key = serializer.serialize(m.getKey());
                    byte[] value = serializer.serialize(m.getValue());
                    emptyMap.put(key, value);
                });
                connection.mSet(emptyMap);
                return true;
            }
        });
        return result;
    }

    @RequestMapping(value={"/get"})
    public String get(final String key) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                byte[] value = connection.get(serializer.serialize((Object)key));
                return (String)serializer.deserialize(value);
            }
        });
        return result;
    }

    @RequestMapping(value={"/hGet"})
    public String hGet(final String key, final String filed) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                byte[] value = connection.hGet(serializer.serialize((Object)key), serializer.serialize((Object)filed));
                return (String)serializer.deserialize(value);
            }
        });
        return result;
    }

    @RequestMapping(value={"/mGet"})
    public String mGet(final String list) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                List list1 = (List)JSONObject.parseObject((String)list, List.class);
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                byte[][] bytes = new byte[list1.size()][];
                for (int i = 0; list1.size() > 0 && i < list1.size(); ++i) {
                    bytes[i] = ((String)list1.get(i)).getBytes();
                }
                List list2 = connection.mGet((byte[][])bytes);
                LinkedHashMap map = new LinkedHashMap();
                int temp = 0;
                for (byte[] next : list2) {
                    String a = next == null ? "" : (String)serializer.deserialize(next);
                    map.put(list1.get(temp++), a);
                }
                return JSONObject.toJSONString(map);
            }
        });
        return result;
    }

    @RequestMapping(value={"/expire"})
    public boolean expire(String key, long expire) {
        StringRedisTemplate redisTemplate = this.getRedisTemplate();
        return redisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
    }

    @RequestMapping(value={"/ttl"})
    public long ttl(final String key) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                Long value = connection.ttl(serializer.serialize((Object)key));
                return (String)serializer.deserialize(value.toString().getBytes());
            }
        });
        return Long.parseLong(result);
    }

    @RequestMapping(value={"/del"})
    public long del(final String key) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                Long value = connection.del((byte[][])new byte[][]{serializer.serialize((Object)key)});
                return (String)serializer.deserialize(value.toString().getBytes());
            }
        });
        return Long.parseLong(result);
    }

    @RequestMapping(value={"/hDel"})
    public long hDel(final String key, final String filed) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                Long value = connection.hDel(serializer.serialize((Object)key), (byte[][])new byte[][]{serializer.serialize((Object)filed)});
                return (String)serializer.deserialize(value.toString().getBytes());
            }
        });
        return Long.parseLong(result);
    }

    @RequestMapping(value={"/incr"})
    public long incr(final String key) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                Long value = connection.incr(serializer.serialize((Object)key));
                return (String)serializer.deserialize(value.toString().getBytes());
            }
        });
        return Long.parseLong(result);
    }

    @RequestMapping(value={"/incrByLong"})
    public long incrByLong(final String key, final long num) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                Long value = connection.incrBy(serializer.serialize((Object)key), num);
                return (String)serializer.deserialize(value.toString().getBytes());
            }
        });
        return Long.parseLong(result);
    }

    @RequestMapping(value={"/incrByDouble"})
    public double incrByDouble(final String key, final double num) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                Double value = connection.incrBy(serializer.serialize((Object)key), num);
                return (String)serializer.deserialize(value.toString().getBytes());
            }
        });
        return Double.parseDouble(result);
    }

    @RequestMapping(value={"/getSet"})
    public String getSet(final String key, final String filed) {
        final StringRedisTemplate redisTemplate = this.getRedisTemplate();
        String result = (String)redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = redisTemplate.getStringSerializer();
                byte[] value = connection.getSet(serializer.serialize((Object)key), serializer.serialize((Object)filed));
                return (String)serializer.deserialize(value);
            }
        });
        return result;
    }

    @RequestMapping(value={"/getMap"})
    @ResponseBody
    public Map getMap(String key) {
        StringRedisTemplate redisTemplate = this.getRedisTemplate();
        return redisTemplate.opsForHash().entries((Object)key);
    }

    @RequestMapping(value={"/setMap"})
    public void setMap(String key, @RequestBody Map map) {
        StringRedisTemplate redisTemplate = this.getRedisTemplate();
        redisTemplate.opsForHash().putAll((Object)key, map);
    }

    @RequestMapping(value={"/getCode"})
    public synchronized String getCode() {
        String saveDate = this.get("REDIS:CODE:DATE");
        String saveIncr = this.get("REDIS:CODE:INCR");
        String saveIncrRecord = this.get("REDIS:CODE:INCR:RECORD");
        CodeUtil codeUtil = new CodeUtil(saveDate, saveIncr, saveIncrRecord).invoke();
        this.set("REDIS:CODE:DATE", codeUtil.getSaveDate());
        this.set("REDIS:CODE:INCR", Long.parseLong(codeUtil.getSaveIncr()) + 60L + "");
        this.set("REDIS:CODE:INCR:RECORD", codeUtil.getSaveIncrRecord());
        StringBuffer sb = new StringBuffer();
        codeUtil.setSaveIncr(this.get("REDIS:CODE:INCR"));
        int length = codeUtil.getSaveIncr().length();
        for (int i = 1; length < 6 && i < 6 - length; ++i) {
            sb.append("0");
        }
        return Long.parseLong(codeUtil.getSaveDate() + sb.toString() + this.get("REDIS:CODE:INCR")) - 59L + "";
    }
}

