/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util.doc;

import com.alibaba.fastjson.JSONObject;
import com.ella.util.CoreUtil;
import com.ella.util.doc.enums.DocAccount;
import com.ella.util.doc.enums.DocPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class DocClient {
    private static final String loginUrl = "http://showdoc.ellabook.cn/server/index.php?s=/api/user/login&";
    private static final String saveUrl = "http://showdoc.ellabook.cn/server/index.php?s=/api/page/save";
    private static final CookieManager manager = new CookieManager();

    public static DocClient instance() {
        return new DocClient();
    }

    public static String getLoginParam(DocAccount docAccount) {
        return "username=" + docAccount.getUserName() + "&password=" + docAccount.getPassword() + "&v_code=";
    }

    public static String getPageParam(DocPage docPage) {
        StringBuilder sb = new StringBuilder();
        sb.append("page_id=0");
        sb.append("&item_id=" + docPage.getItemId().getValue());
        sb.append("&cat_id=0");
        sb.append("&s_number=99");
        sb.append("&page_title=" + docPage.getPageTitle());
        sb.append("&page_content=" + docPage.getPageContent());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String connect(String connectUrl, String param) throws IOException {
        param = param.replace("\n+", "\n");
        HttpURLConnection conn = null;
        OutputStream os = null;
        InputStream is = null;
        StringBuilder sb = new StringBuilder();
        try {
            URL url = new URL(connectUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            os = conn.getOutputStream();
            IOUtils.write((byte[])param.getBytes("utf-8"), (OutputStream)os);
            is = conn.getInputStream();
            byte[] b = new byte[1024];
            int len = is.read(b);
            while (len != -1) {
                sb.append(new String(b, 0, len, "utf-8"));
                len = is.read(b);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return sb.toString();
    }

    public static void uploadDoc(DocAccount docAccount, DocPage docPage) throws Exception {
        String res;
        JSONObject obj;
        int times = 0;
        CookieHandler.setDefault(manager);
        while ((Integer)(obj = JSONObject.parseObject((String)(res = DocClient.connect(saveUrl, DocClient.getPageParam(docPage))))).get((Object)"error_code") != 0 && (times = DocClient.login(docAccount, times)) < 2) {
        }
    }

    public static void uploadDoc(DocPage docPage) throws Exception {
        DocClient.uploadDoc(null, docPage);
    }

    public static int login(DocAccount docAccount, int n) throws IOException {
        System.out.println(CoreUtil.createCommonsCore("---------------------------"));
        DocClient.connect(loginUrl, DocClient.getLoginParam(docAccount == null ? DocAccount.MC : docAccount));
        return (n < 0 ? 0 : n) + 1;
    }

    static {
        manager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
    }
}

