/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ReadExcelUtils {
    private static Logger logger = LoggerFactory.getLogger(ReadExcelUtils.class);
    private static Workbook wb;
    private static Sheet sheet;
    private static Row row;

    public static List<Map<Integer, Object>> fileToList(MultipartFile file) {
        try {
            String fileName = file.getOriginalFilename();
            String ext = fileName.substring(fileName.lastIndexOf("."));
            wb = ".xls".equals(ext) ? new HSSFWorkbook(file.getInputStream()) : (".xlsx".equals(ext) ? new XSSFWorkbook(file.getInputStream()) : null);
            return ReadExcelUtils.readExcelContent();
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return null;
        }
    }

    public static boolean checkFile(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (StringUtils.isBlank((CharSequence)fileName) || !StringUtils.contains((CharSequence)fileName, (CharSequence)".")) {
            return false;
        }
        String ext = fileName.substring(fileName.lastIndexOf("."));
        return ".xls".equals(ext) || ".xlsx".equals(ext);
    }

    public static List<Map<Integer, Object>> inputStreamToList(String fileName, InputStream is) {
        String ext = fileName.substring(fileName.lastIndexOf("."));
        try {
            wb = ".xls".equals(ext) ? new HSSFWorkbook(is) : (".xlsx".equals(ext) ? new XSSFWorkbook(is) : null);
            return ReadExcelUtils.readExcelContent();
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return null;
        }
    }

    private ReadExcelUtils(String filepath) {
        if (filepath == null) {
            return;
        }
        String ext = filepath.substring(filepath.lastIndexOf("."));
        try {
            FileInputStream is = new FileInputStream(filepath);
            wb = ".xls".equals(ext) ? new HSSFWorkbook((InputStream)is) : (".xlsx".equals(ext) ? new XSSFWorkbook((InputStream)is) : null);
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFoundException", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
        }
    }

    private String[] readExcelTitle() throws Exception {
        if (wb == null) {
            logger.info("Workbook\u5bf9\u8c61\u4e3a\u7a7a");
            return null;
        }
        sheet = wb.getSheetAt(0);
        row = sheet.getRow(0);
        int colNum = row.getPhysicalNumberOfCells();
        String[] title = new String[colNum];
        for (int i = 0; i < colNum; ++i) {
            title[i] = row.getCell(i).getStringCellValue();
        }
        return title;
    }

    private static List<Map<Integer, Object>> readExcelContent() throws Exception {
        if (wb == null) {
            logger.info("Workbook\u5bf9\u8c61\u4e3a\u7a7a");
            return null;
        }
        ArrayList<Map<Integer, Object>> content = new ArrayList<Map<Integer, Object>>();
        sheet = wb.getSheetAt(0);
        int rowNum = sheet.getLastRowNum();
        row = sheet.getRow(0);
        int colNum = row.getPhysicalNumberOfCells();
        for (int i = 1; i <= rowNum; ++i) {
            row = sheet.getRow(i);
            if (null == row || null == row.getCell(0) || StringUtils.isBlank((CharSequence)row.getCell(0).getStringCellValue())) continue;
            HashMap<Integer, Object> cellValue = new HashMap<Integer, Object>();
            for (int j = 0; j < colNum; ++j) {
                Object obj = ReadExcelUtils.getCellFormatValue(row.getCell(j));
                cellValue.put(j, obj);
            }
            content.add(cellValue);
        }
        return content;
    }

    private static Object getCellFormatValue(Cell cell) {
        Object cellValue = "";
        if (null == cell) {
            return cellValue;
        }
        switch (cell.getCellType()) {
            case 0: {
                cell.setCellType(1);
                cellValue = cell.getStringCellValue();
                break;
            }
            case 2: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = cell.getDateCellValue();
                    break;
                }
                cellValue = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case 1: {
                cellValue = cell.getRichStringCellValue().getString();
                break;
            }
        }
        return cellValue;
    }

    public static String readExcel(InputStream in) throws FileNotFoundException {
        JSONArray ja = new JSONArray();
        JSONObject jsonObject = null;
        XSSFSheet sheet = null;
        Row row = null;
        try {
            XSSFWorkbook xssfworkbook = new XSSFWorkbook(in);
            sheet = xssfworkbook.getSheetAt(0);
            int rowNum = sheet.getLastRowNum();
            row = sheet.getRow(0);
            int colNum = row.getPhysicalNumberOfCells();
            for (int i = 1; i <= rowNum; ++i) {
                jsonObject = new JSONObject();
                row = sheet.getRow(i);
                for (int j = 0; j < colNum; ++j) {
                    jsonObject.put(String.valueOf(j), (Object)ReadExcelUtils.getCellFormatValue1(row.getCell(j)).trim());
                }
                ja.add((Object)jsonObject);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return ja.toString();
    }

    private static String getCellFormatValue1(Cell cell) {
        String cellValue;
        block7: {
            block6: {
                cellValue = "";
                if (cell == null) break block6;
                switch (cell.getCellType()) {
                    case 0: {
                        cellValue = String.valueOf(cell.getNumericCellValue());
                    }
                    case 2: {
                        if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                            Date date = cell.getDateCellValue();
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                            cellValue = sdf.format(date);
                            break;
                        }
                        break block7;
                    }
                    case 1: {
                        cellValue = cell.getRichStringCellValue().getString();
                        break;
                    }
                    default: {
                        cellValue = " ";
                        break;
                    }
                }
                break block7;
            }
            cellValue = "";
        }
        return cellValue;
    }
}

