/*
 * Decompiled with CFR 0.152.
 */
package com.ella.util;

import com.ella.entity.operation.User;
import com.ella.util.BatchProcess;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class BatchHandlerUtil<T> {
    public void batchResolve(List<T> list, int batchSize, BatchProcess resolve) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (int i = 0; i < list.size(); i += batchSize) {
            int end = i + batchSize;
            if (end > list.size()) {
                end = list.size();
            }
            List<T> items = list.subList(i, end);
            resolve.resolve(items);
        }
    }

    public static void main(String[] args) {
        ArrayList<User> userList = new ArrayList<User>();
        User user = User.builder().userAccount("F1111").userName("\u5f20\u4e09").build();
        userList.add(user);
        new BatchHandlerUtil<User>().batchResolve(userList, 1000, item -> {});
    }
}

