/*
 * Decompiled with CFR 0.152.
 */
package ellax.log.pojo;

import android.os.Bundle;
import android.util.SparseArray;
import ellax.base.IdRetriever;
import ellax.log.IReusePage;
import ellax.log.Logger;
import ellax.log.NameProvider;
import ellax.log.pojo.Host;
import ellax.log.pojo.Log;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public class LogRecord {
    private static final SimpleDateFormat sSimpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());
    private String id;
    private String cid;
    private String date;
    private String num;
    private String enter;
    private String channel;
    private String version;
    private String model;
    private String sn;
    private String ip;
    private String locate;
    private List<Host> hosts = new CopyOnWriteArrayList<Host>();
    private transient int count;
    private transient SparseArray<Host> mOpenPage = new SparseArray();
    private transient Log root;

    private LogRecord() {
    }

    public static LogRecord create(Log log, IdRetriever idRetriever, Bundle bundle, int num, String ip) {
        LogRecord record = new LogRecord();
        record.root = log;
        record.id = idRetriever.getUid();
        record.cid = idRetriever.getCid();
        record.channel = bundle.getString("channel");
        record.version = bundle.getString("version");
        record.model = bundle.getString("device");
        record.sn = bundle.getString("sn");
        record.enter = sSimpleDateFormat.format(Logger.getEnterDate());
        record.date = record.enter.substring(0, 8);
        record.ip = ip;
        long ll = Long.parseLong(record.date);
        record.num = String.valueOf(ll * 10000L + (long)num);
        return record;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void enter(Object object, NameProvider provider) {
        ++this.count;
        String name = provider.getShortNameFor(object);
        if (name == null) {
            if (object instanceof IReusePage) {
                name = ((IReusePage)object).getHost();
            }
            if (name == null) {
                name = this.getPageInfo(object);
            }
        }
        Host host = Host.create(name);
        this.hosts.add(host);
        this.mOpenPage.put(object.hashCode(), (Object)host);
        this.check();
    }

    public void exit(Object object) {
        int key = object.hashCode();
        Host host = (Host)this.mOpenPage.get(key);
        if (host != null) {
            host.leave();
            this.mOpenPage.remove(key);
        }
    }

    public void add(String event, String message, Integer tag) {
        ++this.count;
        if (this.hosts != null && this.hosts.size() > 0) {
            this.hosts.get(this.hosts.size() - 1).add(event, message, tag);
        } else {
            android.util.Log.e((String)"xlog", (String)"no host available");
        }
        this.check();
    }

    private String getPageInfo(Object object) {
        return object.getClass().getName();
    }

    public String getNum() {
        return this.num;
    }

    private void check() {
        if (this.count >= 10) {
            this.root.saveLog(this, false);
            this.count = 0;
        }
    }

    public void print() {
        if (this.hosts != null) {
            for (Host host : this.hosts) {
                android.util.Log.d((String)"xlog", (String)host.toString());
            }
        }
    }

    public String getLocate() {
        return this.locate;
    }

    public void setLocate(String locate) {
        this.locate = locate;
    }
}

