/*
 * Decompiled with CFR 0.152.
 */
package ellax.log;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import ellax.log.InspectFragment;
import ellax.log.Logger;
import ellax.log.NonInspectActivity;
import java.util.HashSet;
import java.util.Set;

class WatchDog
extends FragmentManager.FragmentLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private final int MESSAGE_RESET = 1;
    private final Set<Integer> mPageArray = new HashSet<Integer>();
    private final Set<Integer> mForegroundActivityArray = new HashSet<Integer>();
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                WatchDog.this.active = false;
                Logger.exit();
            }
            return true;
        }
    });
    private boolean active;
    private Paused mAfterPaused;

    WatchDog(Runnable afterPaused) {
        this.mAfterPaused = new Paused(afterPaused);
    }

    public void onFragmentCreated(FragmentManager fm, Fragment f, Bundle savedInstanceState) {
        this.fragmentEnter(f);
    }

    public void onFragmentResumed(FragmentManager fm, Fragment f) {
        if (f instanceof InspectFragment) {
            this.mPageArray.add(f.hashCode());
        }
        this.fragmentEnter(f);
    }

    public void onFragmentPaused(FragmentManager fm, Fragment f) {
        if (f instanceof InspectFragment) {
            this.mPageArray.remove(f.hashCode());
            Logger.leave(f);
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.mHandler.removeMessages(1);
        this.mHandler.removeCallbacks((Runnable)this.mAfterPaused);
        if (!this.active) {
            this.active = Logger.active();
        }
        this.mPageArray.add(activity.hashCode());
        this.activityEnter(activity);
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.mHandler.removeMessages(1);
        this.mHandler.removeCallbacks((Runnable)this.mAfterPaused);
        if (!this.active) {
            this.active = Logger.active();
        }
        this.activityEnter(activity);
        this.mForegroundActivityArray.add(activity.hashCode());
    }

    public void onActivityPaused(Activity activity) {
        Logger.leave(activity);
        this.mForegroundActivityArray.remove(activity.hashCode());
        if (this.mForegroundActivityArray.isEmpty()) {
            Log.d((String)"xlog", (String)"foreground array is empty, schedule to pause");
            this.mHandler.postDelayed((Runnable)this.mAfterPaused, 2000L);
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mPageArray.remove(activity.hashCode());
        if (this.mPageArray.isEmpty()) {
            Log.d((String)"xlog", (String)"array is empty, schedule to exit");
            this.mHandler.sendEmptyMessageDelayed(1, 1000L);
        }
    }

    private void activityEnter(Activity activity) {
        if (activity instanceof FragmentActivity) {
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this, true);
        }
        if (activity instanceof NonInspectActivity) {
            return;
        }
        Logger.enter(activity);
    }

    private void fragmentEnter(Fragment f) {
        if (f instanceof InspectFragment && f.getUserVisibleHint()) {
            Logger.enter(f);
        }
    }

    private static class Paused
    implements Runnable {
        private Runnable mRunnable;

        public Paused(Runnable runnable) {
            this.mRunnable = runnable;
        }

        @Override
        public void run() {
            Log.d((String)"xlog", (String)"paused");
            if (this.mRunnable != null) {
                this.mRunnable.run();
            }
        }
    }
}

