/*
 * Decompiled with CFR 0.152.
 */
package ellax.bookmanager;

import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liulishuo.okdownload.DownloadListener;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.core.Util;
import com.liulishuo.okdownload.core.breakpoint.BlockInfo;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import com.liulishuo.okdownload.core.cause.EndCause;
import com.liulishuo.okdownload.core.listener.DownloadListener4;
import com.liulishuo.okdownload.core.listener.assist.Listener4Assist;
import ellax.bookmanager.BookEvent;
import ellax.bookmanager.BookManager;
import ellax.bookmanager.DownloadInfoCallback;
import ellax.bookmanager.DownloadManager2;
import ellax.bookmanager.InstallManager;
import ellax.bookmanager.R;
import ellax.bookmanager.ReaderResource;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class DownloadQueue
extends DownloadListener4
implements Runnable {
    private static final Executor SERIAL_EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory((String)"DynamicSerial", (boolean)false));
    private volatile boolean shutedDown = false;
    private volatile boolean looping = false;
    private volatile DownloadTask runningTask;
    private final ArrayList<ReaderResource> taskList;
    private static final int ID_INVALID = 0;
    private int minimalProgressCallbackMs;
    private DownloadInfoCallback mDownloadInfoCallback;
    private long minimalAvailableSpace;
    private int maxRetryCount;
    private Handler mHandler;
    private DownloadManager2 mDownloadManager;
    private String errorTask;
    private int retry;

    DownloadQueue(DownloadManager2 downloadManager, Handler handler, int minimalProgressCallbackMs, long minimalAvailableSpace, int maxRetryCount) {
        this.mDownloadManager = downloadManager;
        this.mHandler = handler;
        this.minimalProgressCallbackMs = minimalProgressCallbackMs;
        this.minimalAvailableSpace = minimalAvailableSpace;
        this.maxRetryCount = maxRetryCount;
        this.taskList = new ArrayList();
        this.mDownloadInfoCallback = BookManager.getDownloadInfoCallback();
    }

    void setMinimalProgressCallbackMs(int minimalProgressCallbackMs) {
        this.minimalProgressCallbackMs = minimalProgressCallbackMs;
    }

    void setMinimalAvailableSpace(long minimalAvailableSpace) {
        this.minimalAvailableSpace = minimalAvailableSpace;
    }

    void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(ReaderResource task) {
        DownloadQueue downloadQueue = this;
        synchronized (downloadQueue) {
            if (this.processing(task)) {
                return false;
            }
            if (task.topPriority) {
                this.taskList.add(0, task);
            } else {
                this.taskList.add(task);
            }
            if (!this.looping) {
                this.looping = true;
                this.startNewLooper();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dequeue(ReaderResource resource) {
        if (resource.compareTo(this.getResource()) == 0) {
            this.runningTask.cancel();
            this.runningTask = null;
            return true;
        }
        ArrayList<ReaderResource> arrayList = this.taskList;
        synchronized (arrayList) {
            for (int i = 0; i < this.taskList.size(); ++i) {
                if (this.taskList.get(i).compareTo(resource) != 0) continue;
                this.taskList.remove(i);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processing(ReaderResource resource) {
        if (resource.compareTo(this.getResource()) == 0) {
            return true;
        }
        ArrayList<ReaderResource> arrayList = this.taskList;
        synchronized (arrayList) {
            for (ReaderResource rr : this.taskList) {
                if (rr.compareTo(resource) != 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        DownloadQueue downloadQueue = this;
        synchronized (downloadQueue) {
            if (this.runningTask != null) {
                this.runningTask.cancel();
            }
            this.runningTask = null;
            this.taskList.clear();
        }
    }

    public int getWorkingTaskId() {
        return this.runningTask != null ? this.runningTask.getId() : 0;
    }

    int getTaskCount() {
        return this.taskList.size() + (this.runningTask == null ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTaskCountByTag(String tag) {
        int count = 0;
        ArrayList<ReaderResource> arrayList = this.taskList;
        synchronized (arrayList) {
            for (ReaderResource resource : this.taskList) {
                if (!resource.match(tag)) continue;
                ++count;
            }
        }
        ReaderResource resource = this.getResource();
        if (resource != null && resource.match(tag)) {
            ++count;
        }
        return count;
    }

    synchronized void shutdown() {
        this.shutedDown = true;
        if (this.runningTask != null) {
            this.runningTask.cancel();
        }
        this.taskList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.errorTask = null;
        while (!this.shutedDown) {
            ReaderResource resource;
            DownloadQueue downloadQueue = this;
            synchronized (downloadQueue) {
                if (this.taskList.isEmpty()) {
                    this.runningTask = null;
                    this.looping = false;
                    this.mHandler.sendEmptyMessageDelayed(0, 20000L);
                    break;
                }
                resource = this.taskList.remove(0);
            }
            this.mHandler.removeMessages(0);
            this.executeResource(resource);
        }
    }

    private void executeResource(ReaderResource resource) {
        ReaderResource downloadableResource;
        ReaderResource readerResource = downloadableResource = resource == null ? null : resource.getDownloadableResource();
        while (downloadableResource != null) {
            boolean isErrorTask;
            if (BookManager.getAvailableSpace() < this.minimalAvailableSpace) {
                this.postSpaceError();
                break;
            }
            boolean bl = isErrorTask = this.errorTask != null && this.errorTask.equals(resource.bookCode);
            if (isErrorTask) {
                if (this.cannotRetry()) {
                    Log.d((String)"BookManager", (String)("retry task but failed: " + downloadableResource.url));
                    break;
                }
                Log.d((String)"BookManager", (String)("retry task: " + downloadableResource.url));
                ++this.retry;
            } else {
                this.retry = 0;
            }
            DownloadTask task = new DownloadTask.Builder(downloadableResource.url, ReaderResource.getTempPath(downloadableResource, ".tmp")).setMinIntervalMillisCallbackProcess(this.minimalProgressCallbackMs).setWifiRequired(resource.wifi).setAutoCallbackToUIThread(false).build();
            this.errorTask = null;
            task.addTag(R.id.resource, (Object)resource);
            task.execute((DownloadListener)this);
            downloadableResource = downloadableResource.getDownloadableResource();
        }
    }

    private void startNewLooper() {
        SERIAL_EXECUTOR.execute(this);
    }

    public void taskStart(@NonNull DownloadTask task) {
        this.runningTask = task;
        ReaderResource resource = this.getResource(task);
        BreakpointInfo blockInfo = task.getInfo();
        BookEvent event = new BookEvent(resource.bookCode, -5);
        event.progress = blockInfo == null ? resource.calculateProgress(task.getUrl(), 0L, 0L) : resource.calculateProgress(task.getUrl(), blockInfo.getTotalOffset(), blockInfo.getTotalLength());
        this.mDownloadManager.post(event);
        if (this.mDownloadInfoCallback != null) {
            this.mDownloadInfoCallback.taskStart(resource);
        }
    }

    public void connectStart(@NonNull DownloadTask task, int blockIndex, @NonNull Map<String, List<String>> requestHeaderFields) {
        if (this.mDownloadInfoCallback != null) {
            this.mDownloadInfoCallback.connectStart(this.getResource(task), blockIndex);
        }
    }

    public void connectEnd(@NonNull DownloadTask task, int blockIndex, int responseCode, @NonNull Map<String, List<String>> responseHeaderFields) {
        if (this.mDownloadInfoCallback != null) {
            this.mDownloadInfoCallback.connectEnd(this.getResource(task), blockIndex);
        }
    }

    public void infoReady(DownloadTask task, @NonNull BreakpointInfo info, boolean fromBreakpoint, @NonNull Listener4Assist.Listener4Model model) {
        if (this.mDownloadInfoCallback != null) {
            this.mDownloadInfoCallback.infoReady(this.getResource(task));
        }
    }

    public void progressBlock(DownloadTask task, int blockIndex, long currentBlockOffset) {
        if (this.mDownloadInfoCallback != null) {
            this.mDownloadInfoCallback.progressBlock(this.getResource(task), blockIndex, currentBlockOffset);
        }
    }

    public void progress(DownloadTask task, long currentOffset) {
        ReaderResource resource = this.getResource(task);
        BookEvent event = new BookEvent(resource.bookCode, -3);
        event.progress = resource.calculateProgress(task.getUrl(), currentOffset, task.getInfo().getTotalLength());
        this.mDownloadManager.post(event);
        if (this.mDownloadInfoCallback != null) {
            this.mDownloadInfoCallback.progress(resource, currentOffset, event.progress);
        }
    }

    public void blockEnd(DownloadTask task, int blockIndex, BlockInfo info) {
        if (this.mDownloadInfoCallback != null) {
            this.mDownloadInfoCallback.blockEnd(this.getResource(task), blockIndex);
        }
    }

    public void taskEnd(DownloadTask task, EndCause cause, @Nullable Exception realCause, @NonNull Listener4Assist.Listener4Model model) {
        ReaderResource resource = this.getResource(task);
        if (cause == EndCause.COMPLETED) {
            this.errorTask = null;
            this.downloadComplete(task.getUrl(), this.getResource(task));
            if (resource.isReadyForInstall()) {
                this.mDownloadManager.post(new BookEvent(resource.bookCode, -2));
                InstallManager.install(resource, this.mDownloadManager);
            }
        } else if (cause == EndCause.ERROR) {
            Log.e((String)"BookManager", (String)task.getUrl());
            this.errorTask = resource.bookCode;
            if (this.cannotRetry()) {
                this.mDownloadManager.post(new BookEvent(resource.bookCode, -1));
            }
        } else if (cause == EndCause.CANCELED) {
            this.errorTask = resource.bookCode;
            this.retry = this.maxRetryCount;
        } else {
            this.errorTask = resource.bookCode;
            this.retry = this.maxRetryCount;
            int type = this.getEventType(cause);
            this.mDownloadManager.post(new BookEvent(resource.bookCode, type));
            if (type == -11) {
                this.postSpaceError();
            }
        }
        this.taskEnd(task);
        if (realCause != null) {
            realCause.printStackTrace();
        }
        if (this.mDownloadInfoCallback != null) {
            this.mDownloadInfoCallback.taskEnd(resource, this.getEndDesc(cause));
        }
    }

    private int getEventType(EndCause cause) {
        switch (cause) {
            case FILE_BUSY: {
                return -9;
            }
            case SAME_TASK_BUSY: {
                return -10;
            }
            case PRE_ALLOCATE_FAILED: {
                return -11;
            }
        }
        return -8;
    }

    private String getEndDesc(EndCause cause) {
        switch (cause) {
            case ERROR: {
                return "ERROR";
            }
            case COMPLETED: {
                return "COMPLETED";
            }
            case CANCELED: {
                return "CANCELED";
            }
            case FILE_BUSY: {
                return "FILE_BUSY";
            }
            case SAME_TASK_BUSY: {
                return "SAME_TASK_BUSY";
            }
            case PRE_ALLOCATE_FAILED: {
                return "PRE_ALLOCATE_FAILED";
            }
        }
        return "UNKNOWN";
    }

    private void downloadComplete(String url, ReaderResource resource) {
        do {
            if (!resource.url.equals(url)) continue;
            File file = ReaderResource.getTempPath(resource);
            File downloaded = ReaderResource.getTempPath(resource, ".tmp");
            if (downloaded.renameTo(file)) break;
            Log.e((String)"BookManager", (String)("failed to rename temp file: " + downloaded.getPath()));
            break;
        } while ((resource = resource.nextResource) != null);
    }

    private boolean cannotRetry() {
        return this.retry >= this.maxRetryCount;
    }

    private void taskEnd(DownloadTask task) {
        if (task == this.runningTask) {
            this.runningTask = null;
        }
    }

    private ReaderResource getResource(DownloadTask task) {
        if (task != null) {
            return (ReaderResource)task.getTag(R.id.resource);
        }
        return null;
    }

    private ReaderResource getResource() {
        return this.getResource(this.runningTask);
    }

    private void postSpaceError() {
        this.clear();
        BookEvent event = new BookEvent("", -12);
        event.setExtra("space_error");
        this.mDownloadManager.post(event);
    }
}

