/*
 * Decompiled with CFR 0.152.
 */
package ellax.bookmanager;

import android.os.Handler;
import android.os.Message;
import ellax.bookmanager.BookEvent;
import ellax.bookmanager.BookManager;
import ellax.bookmanager.DownloadInfoCallback;
import ellax.bookmanager.DownloadQueue;
import ellax.bookmanager.InstallCallback;
import ellax.bookmanager.InstallManager;
import ellax.bookmanager.Poster;
import ellax.bookmanager.ReaderResource;

public class DownloadManager2
implements InstallManager.Install {
    static final String FILE_SUFFIX = ".eb";
    static final String TMP_FILE_SUFFIX = ".tmp";
    private int minimalProgressCallbackMs = 300;
    private long minimalAvailableSpace = 629145600L;
    private int maxRetryCount = 2;
    private Poster mPoster;
    private Handler mHandler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (DownloadManager2.this.mDownloadQueue != null && DownloadManager2.this.mDownloadQueue.getTaskCount() == 0) {
                DownloadManager2.this.mDownloadQueue.shutdown();
                DownloadManager2.this.mDownloadQueue = null;
            }
            return true;
        }
    });
    private DownloadQueue mDownloadQueue;

    DownloadManager2(Poster poster) {
        this.mPoster = poster;
    }

    void setMinimalAvailableSpace(long minimalAvailableSpace) {
        this.minimalAvailableSpace = minimalAvailableSpace;
        if (this.mDownloadQueue != null) {
            this.mDownloadQueue.setMinimalAvailableSpace(minimalAvailableSpace);
        }
    }

    void setMinimalProgressCallbackMs(int minimalProgressCallbackMs) {
        this.minimalProgressCallbackMs = minimalProgressCallbackMs;
        if (this.mDownloadQueue != null) {
            this.mDownloadQueue.setMinimalProgressCallbackMs(minimalProgressCallbackMs);
        }
    }

    void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        if (this.mDownloadQueue != null) {
            this.mDownloadQueue.setMaxRetryCount(maxRetryCount);
        }
    }

    void addTask(final ReaderResource resource, boolean tryMode, final boolean isOnlyWifi) {
        this.dispatchAddTask(resource);
        resource.setTryMode(tryMode);
        resource.transfer(new InstallCallback(){

            @Override
            public void complete(boolean success) {
                DownloadManager2.this.addTaskInternal(resource, isOnlyWifi);
            }
        });
    }

    private void dispatchAddTask(ReaderResource resource) {
        DownloadInfoCallback callback = BookManager.getDownloadInfoCallback();
        if (callback != null) {
            callback.addTask(resource);
        }
    }

    private void dispatchTaskEnd(ReaderResource resource, String why) {
        DownloadInfoCallback callback = BookManager.getDownloadInfoCallback();
        if (callback != null) {
            callback.taskEnd(resource, why);
        }
    }

    private void dispatchTaskAdded(ReaderResource resource, String reason) {
        DownloadInfoCallback callback = BookManager.getDownloadInfoCallback();
        if (callback != null) {
            callback.taskAdded(resource, reason);
        }
    }

    synchronized void post(Object o) {
        if (this.mPoster == null) {
            throw new RuntimeException("poster is not set");
        }
        this.mPoster.post(o);
    }

    private void addTaskInternal(ReaderResource resource, boolean isOnlyWifi) {
        boolean success;
        if (resource.isAllInstalledInUserDir() || resource.isAllInstalled()) {
            this.dispatchTaskEnd(resource, "already installed");
            return;
        }
        if (resource.isReadyForInstall()) {
            this.post(new BookEvent(resource.bookCode, -2));
            InstallManager.install(resource, this);
            return;
        }
        resource.wifi = isOnlyWifi;
        if (this.mDownloadQueue == null) {
            this.mDownloadQueue = new DownloadQueue(this, this.mHandler, this.minimalProgressCallbackMs, this.minimalAvailableSpace, this.maxRetryCount);
        }
        this.dispatchTaskAdded(resource, (success = this.mDownloadQueue.enqueue(resource)) ? "success" : "add error");
        if (success) {
            this.post(new BookEvent(resource.bookCode, -5));
        }
    }

    void pauseTask(ReaderResource resource) {
        if (this.mDownloadQueue != null) {
            this.mDownloadQueue.dequeue(resource);
        }
        this.post(new BookEvent(resource.bookCode, -4));
    }

    void pauseAllTasks() {
        if (this.mDownloadQueue != null) {
            this.mDownloadQueue.clear();
        }
        this.post(new BookEvent("", -12));
    }

    void deleteTask(ReaderResource resource) {
        BookManager.pause(resource);
    }

    boolean isDownloading(ReaderResource resource) {
        return this.mDownloadQueue != null && this.mDownloadQueue.processing(resource);
    }

    int getDownloadCount() {
        if (this.mDownloadQueue == null) {
            return 0;
        }
        return this.mDownloadQueue.getTaskCount();
    }

    int getDownloadCountByTag(String tag) {
        if (this.mDownloadQueue == null) {
            return 0;
        }
        if (tag == null) {
            return this.mDownloadQueue.getTaskCount();
        }
        return this.mDownloadQueue.getTaskCountByTag(tag);
    }

    @Override
    public void start(ReaderResource resource) {
        this.post(new BookEvent(resource.bookCode, -7));
    }

    @Override
    public void complete(ReaderResource resource, boolean success) {
        BookEvent event = new BookEvent(resource.bookCode, -6);
        event.success = success;
        this.post(event);
    }
}

