package ellax.base.mvi

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.DefaultLifecycleObserver
import androidx.lifecycle.LifecycleOwner
import androidx.viewbinding.ViewBinding
import ellax.base.EllaBaseFragment
import ellax.base.IBaseView
import java.lang.reflect.ParameterizedType

/**
 * Date: 2023/4/25 14:07
 * Author: funaihui@ellabook.cn
 * Describe: MVI 架构的fragment
 **/
open class BaseMVIFragment<T : ViewBinding> : EllaBaseFragment(), IBaseView {

    protected lateinit var binding:T

    @Suppress("UNCHECKED_CAST")
    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        val type = javaClass.genericSuperclass
        val clazz = (type as ParameterizedType).actualTypeArguments[0] as Class<T>
        val method = clazz.getMethod("inflate", LayoutInflater::class.java, ViewGroup::class.java, Boolean::class.java)
        binding = method.invoke(null, layoutInflater, container, false) as T
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        // 业务view
        initView()
        // 初始化数据
        initData()
        // 初始化viewModel，处理view显示
        initViewModel()
        // 绑定事件监听
        initListener()
    }

    override fun getLayoutFile(): Int {
        return 0
    }
}