package ellax.base.helper;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Iterator;

/**
 * Created by dongdaqing on 2018/4/8.
 */
public class ParamHelper {
    private JSONObject object;

    public ParamHelper() {
        object = new JSONObject();
    }

    public ParamHelper(JSONObject object) {
        this.object = object;
    }

    public ParamHelper put(String key, Object value) {
        try {
            if (value != null)
                object.put(key, value);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public ParamHelper putAll(JSONObject object) {
        Iterator<String> iterator = object.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            put(key, object.optString(key));
        }
        return this;
    }

    @Override
    public String toString() {
        return object.toString();
    }

    public JSONObject getObject() {
        return object;
    }
}
