package ellax.base.error;

import java.io.IOException;
import java.net.*;

/**
 * Created by dongdaqing on 2018/4/2.
 */
public class ErrorFactory {
    public static Error getError(Exception e) {
        if (e instanceof IOException) {
            return getNetworkError((IOException) e);
        }
        return new Error(ErrorTypes.PARSE_FAILED);
    }

    public static Error getNetworkError(IOException e) {
        if (e instanceof UnknownHostException) {
            return new Error(ErrorTypes.UNKNOWN_HOST);
        } else if (e instanceof ConnectException) {
            return new Error(ErrorTypes.NETWORK_ERROR);
        } else if (e instanceof NoRouteToHostException) {
            return new Error(ErrorTypes.NO_ROUTE_TO_HOST_ERROR);
        } else if (e instanceof SocketException) {
            return new Error(ErrorTypes.SERVER_ERROR);
        } else if (e instanceof SocketTimeoutException) {
            return new Error(ErrorTypes.TIME_OUT);
        } else {
            return new Error(ErrorTypes.SERVER_ERROR);
        }
    }

    public static Error getError(int httpCode) {
        if (httpCode == 404) {
            return new Error(ErrorTypes.NOT_FOUND);
        }
        return new Error(ErrorTypes.UNKNOWN_ERROR);
    }

    public static Error parseFailed(String reason) {
        return new Error(ErrorTypes.PARSE_FAILED, reason);
    }
}
