package ellax.base.error;

import java.util.Map;

/**
 * Created by dongdaqing on 2018/4/2.
 * 定义应用程序里面的错误
 */
public class Error {
    /**
     * 错误的类型，定义在{@link ErrorTypes}里面
     */
    private int code;
    private String message;
    private Map<String, String> mExtras;
    private Object data;

    private int tag;

    public Error(int code) {
        this(code, null, null);
    }

    public Error(int code, String message) {
        this(code, message, null);
    }

    public Error(int code, String message, Object data) {
        this.code = code;
        this.message = message == null ? ErrorTypes.getMsg(code) : message;
        this.data = data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getMessage() {
        return message;
    }

    public Object getData() {
        return data;
    }

    public boolean is(int code) {
        return this.code == code;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getTag() {
        return tag;
    }

    public void setExtras(Map<String, String> extras) {
        mExtras = extras;
    }

    public String getExtra(String key) {
        if (mExtras == null)
            return null;
        return mExtras.get(key);
    }

    public int getCode() {
        return code;
    }

    /**
     * 判断是否是网络错误
     *
     * @return
     */
    public boolean isNetworkError() {
        return code == ErrorTypes.TIME_OUT ||
                code == ErrorTypes.NETWORK_ERROR ||
                code == ErrorTypes.NO_ROUTE_TO_HOST_ERROR ||
                code == ErrorTypes.UNKNOWN_HOST ||
                code == ErrorTypes.SERVER_ERROR;
    }

    /**
     * 判断是否是业务出错
     *
     * @return
     */
    public boolean isBusinessError() {
        return code == ErrorTypes.BUSINESS_ERROR;
    }

    /**
     * 判断是否是登陆信息过期
     *
     * @return
     */
    public boolean isSessionTimeOut() {
        return code == ErrorTypes.SESSION_TIME_OUT;
    }
}
