package ellax.base;

import android.app.ProgressDialog;
import android.content.Context;

import ellax.base.util.ProgressAdapter;

/**
 * created by dongdaqing 19-2-25 上午11:54
 */
final class ModalProgress extends ProgressAdapter {

    private Context mContext;
    private ProgressDialog mProgressDialog;

    ModalProgress(Context context) {
        mContext = context;
    }

    @Override
    public void showProgress() {
        if (mContext == null)
            return;

        if (mProgressDialog == null) {
            mProgressDialog = new ProgressDialog(mContext);
            mProgressDialog.setMessage(mContext.getString(R.string.loaddata));
        }

        if (!mProgressDialog.isShowing())
            mProgressDialog.show();
    }

    @Override
    public void stopProgress() {
        if (mProgressDialog != null)
            mProgressDialog.dismiss();
    }
}
