/*
 * Decompiled with CFR 0.152.
 */
package ellax.base.helper;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import androidx.annotation.ColorInt;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ShapeHelper {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int LINE = 2;
    public static final int RING = 3;
    public static final int CORNER_ALL = 0;
    public static final int CORNER_LEFT_TOP = 1;
    public static final int CORNER_RIGHT_TOP = 2;
    public static final int CORNER_RIGHT_BOTTOM = 4;
    public static final int CORNER_LEFT_BOTTOM = 8;
    public static final int CORNER_TOP = 3;
    public static final int CORNER_BOTTOM = 12;
    public static final int CORNER_LEFT = 9;
    public static final int CORNER_RIGHT = 6;
    private int shape;
    private float radius;
    private int corner;
    private int solid;
    private int stroke;
    private int strokeColor;
    private int dashWidth;
    private int dashGap;
    private int[] gradients;
    private int gradientType = 0;
    private int width = -1;
    private int height = -1;
    private GradientDrawable.Orientation mOrientation;
    private GradientDrawable mDrawable;

    private ShapeHelper(int shape) {
        this.shape = shape;
    }

    public static ShapeHelper rectangle() {
        return new ShapeHelper(0);
    }

    public static ShapeHelper oval() {
        return new ShapeHelper(1);
    }

    public static ShapeHelper ring() {
        return new ShapeHelper(3);
    }

    public static ShapeHelper with(GradientDrawable drawable) {
        ShapeHelper helper = new ShapeHelper(0);
        helper.mDrawable = drawable;
        return helper;
    }

    public ShapeHelper shape(int shape) {
        this.shape = shape;
        return this;
    }

    public ShapeHelper color(@ColorInt int color) {
        this.solid = color;
        return this;
    }

    public ShapeHelper color(String color) {
        this.solid = Color.parseColor((String)color);
        return this;
    }

    public ShapeHelper corner(int corner) {
        this.corner = corner;
        return this;
    }

    public ShapeHelper radius(float radius) {
        this.radius = radius;
        return this;
    }

    public ShapeHelper stroke(int width) {
        this.stroke = width;
        return this;
    }

    public ShapeHelper strokeColor(int color) {
        this.strokeColor = color;
        return this;
    }

    public ShapeHelper dashWidth(int width) {
        this.dashWidth = width;
        return this;
    }

    public ShapeHelper dashGap(int gap) {
        this.dashGap = gap;
        return this;
    }

    public ShapeHelper gradient(GradientDrawable.Orientation orientation, int[] gradients) {
        this.gradients = gradients;
        this.mOrientation = orientation;
        return this;
    }

    public ShapeHelper gradient(GradientDrawable.Orientation orientation, String ... colors) {
        this.mOrientation = orientation;
        if (colors != null) {
            this.gradients = new int[colors.length];
            for (int i = 0; i < this.gradients.length; ++i) {
                this.gradients[i] = Color.parseColor((String)colors[i]);
            }
        }
        return this;
    }

    public ShapeHelper size(int size) {
        return this.size(size, size);
    }

    public ShapeHelper size(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public Drawable make() {
        GradientDrawable drawable = this.mDrawable;
        if (drawable == null) {
            drawable = this.mOrientation != null ? new GradientDrawable(this.mOrientation, this.gradients) : new GradientDrawable();
        }
        this.mDrawable = null;
        if (this.mOrientation != null) {
            drawable.setGradientType(this.gradientType);
        } else {
            drawable.setColor(this.solid);
        }
        drawable.setShape(this.shape);
        drawable.setStroke(this.stroke, this.strokeColor, (float)this.dashWidth, (float)this.dashGap);
        drawable.setSize(this.width, this.height);
        if (this.corner == 0) {
            drawable.setCornerRadius(this.radius);
        } else {
            float[] radii = new float[8];
            int[] corners = new int[]{1, 2, 4, 8};
            for (int i = 0; i < corners.length; ++i) {
                if ((this.corner & corners[i]) != corners[i]) continue;
                radii[i * 2] = this.radius;
                radii[i * 2 + 1] = this.radius;
            }
            drawable.setCornerRadii(radii);
        }
        return drawable;
    }

    public void into(View ... views) {
        if (views != null) {
            for (View v : views) {
                v.setBackground(this.make());
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Corner {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Shape {
    }
}

