/*
 * Decompiled with CFR 0.152.
 */
package ellax.base.error;

import ellax.base.error.Error;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class ErrorFactory {
    public static Error getError(Exception e) {
        if (e instanceof IOException) {
            return ErrorFactory.getNetworkError((IOException)e);
        }
        return new Error(-1300);
    }

    public static Error getNetworkError(IOException e) {
        if (e instanceof UnknownHostException) {
            return new Error(-5100);
        }
        if (e instanceof ConnectException) {
            return new Error(-5200);
        }
        if (e instanceof NoRouteToHostException) {
            return new Error(-5400);
        }
        if (e instanceof SocketException) {
            return new Error(-5300);
        }
        if (e instanceof SocketTimeoutException) {
            return new Error(-5000);
        }
        return new Error(-5300);
    }

    public static Error getError(int httpCode) {
        if (httpCode == 404) {
            return new Error(-1400);
        }
        return new Error(-1);
    }

    public static Error parseFailed(String reason) {
        return new Error(-1300, reason);
    }
}

