/*
 * Decompiled with CFR 0.152.
 */
package ellax.base;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import ellax.base.ActivityResultCallback;
import ellax.base.ActivityResultCallbackHolder;
import ellax.base.BaseDelegate;
import ellax.base.EllaView;
import ellax.base.FinishOptions;
import ellax.base.IProgress;
import ellax.base.IRouteDelegate;
import ellax.base.error.Error;
import ellax.base.helper.ToastHelper;
import ellax.base.lifecycle.Lifecycle;
import ellax.base.lifecycle.LifecycleListener;
import ellax.base.lifecycle.LifecycleManager;
import ellax.base.transition.TransitionManager;
import ellax.base.transition.TransitionStateListener;
import ellax.notch.WindowHelperLegacyKt;
import java.util.ArrayList;

public class EllaBaseActivity
extends AppCompatActivity
implements Lifecycle,
EllaView,
IRouteDelegate,
TransitionStateListener,
ActivityResultCallbackHolder {
    private static boolean enableFullScreen = true;
    private BaseDelegate mDelegate;
    private LifecycleManager mLifecycleManager = new LifecycleManager();
    private ArrayList<ActivityResultCallback> mActivityResultCallbacks;

    public void setContentView(View view) {
        super.setContentView(view);
        this.makeWindowFullScreen();
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        this.makeWindowFullScreen();
    }

    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        this.makeWindowFullScreen();
    }

    public int getStatusView() {
        return -1;
    }

    public void makeWindowFullScreen() {
        if (enableFullScreen) {
            WindowHelperLegacyKt.makeWindowFullScreenL((FragmentActivity)this, (boolean)this.darkStatusIcon(), this.getStatusView() == -1 ? null : this.findViewById(this.getStatusView()));
        }
    }

    public static void setEnableFullScreen(boolean enableFullScreen) {
        EllaBaseActivity.enableFullScreen = enableFullScreen;
    }

    public boolean darkStatusIcon() {
        return true;
    }

    @Override
    public final void showProgress() {
        this.getBaseDelegate().showProgress();
    }

    @Override
    public final void update(long total, long current, float percent, String tag) {
        this.getBaseDelegate().update(total, current, percent, tag);
    }

    @Override
    public final void stopProgress() {
        this.getBaseDelegate().stopProgress();
    }

    @Override
    public void handleError(Error error) {
        if (error.isNetworkError()) {
            this.handleNetworkError(error);
        } else if (error.is(-3000)) {
            this.handleEmptyDataError(error);
        } else {
            ToastHelper.showToast(error.getMessage());
        }
    }

    protected void handleNetworkError(Error error) {
        if (!TransitionManager.notifyPageStateChange((int)this.hashCode(), (int)0x7FFFFFFD)) {
            ToastHelper.showToast(error.getMessage());
        }
    }

    protected void handleEmptyDataError(Error error) {
        if (!TransitionManager.notifyPageStateChange((int)this.hashCode(), (int)0x7FFFFFFC)) {
            ToastHelper.showToast(error.getMessage());
        }
    }

    protected IProgress provideProgress() {
        return null;
    }

    @Override
    public final void route(Intent intent, Bundle options, int requestCode) {
        this.getBaseDelegate().route(intent, options, requestCode);
    }

    @Override
    public final void finish(FinishOptions options) {
        this.getBaseDelegate().finish(options);
    }

    private BaseDelegate getBaseDelegate() {
        if (this.mDelegate == null) {
            this.mDelegate = new BaseDelegate((Activity)this, this.provideProgress());
        }
        return this.mDelegate;
    }

    public void onViewStateChanged(int state, View view) {
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLifecycleManager.onLifecycleStart();
    }

    protected void onStop() {
        this.mLifecycleManager.onLifecycleStop();
        super.onStop();
    }

    protected void onDestroy() {
        this.mLifecycleManager.onLifecycleDestroy();
        super.onDestroy();
    }

    public void addListener(LifecycleListener listener) {
        this.mLifecycleManager.addListener(listener);
    }

    public void removeListener(LifecycleListener listener) {
        this.mLifecycleManager.removeListener(listener);
    }

    @Override
    public void addActivityResultCallback(ActivityResultCallback callback) {
        if (this.mActivityResultCallbacks == null) {
            this.mActivityResultCallbacks = new ArrayList();
        }
        this.mActivityResultCallbacks.add(callback);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.mActivityResultCallbacks != null) {
            for (ActivityResultCallback callback : this.mActivityResultCallbacks) {
                callback.onActivityResult(requestCode, resultCode, data);
            }
        }
    }
}

