/*
 * Decompiled with CFR 0.152.
 */
package ellax.base;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import ellax.base.ActivityFinishHelper;
import ellax.base.FinishOptions;
import ellax.base.IProgress;
import ellax.base.IRouteDelegate;
import ellax.base.ModalProgress;
import ellax.base.TransitionProgress;
import ellax.base.transition.TransitionManager;

class BaseDelegate
implements IRouteDelegate,
IProgress {
    private Object mHost;
    private IProgress mProgress;

    BaseDelegate(Activity host, IProgress progress) {
        this.mHost = host;
        this.mProgress = progress;
        if (this.mProgress == null) {
            this.mProgress = TransitionManager.transitionEnabled((Object)this.mHost) ? new TransitionProgress(host) : new ModalProgress((Context)host);
        }
    }

    BaseDelegate(androidx.fragment.app.Fragment host, IProgress progress) {
        this.mHost = host;
        this.mProgress = progress;
        if (this.mProgress == null) {
            this.mProgress = TransitionManager.transitionEnabled((Object)this.mHost) ? new TransitionProgress(host) : new ModalProgress((Context)host.getActivity());
        }
    }

    BaseDelegate(Fragment host, IProgress progress) {
        this.mHost = host;
        this.mProgress = progress;
        if (this.mProgress == null) {
            this.mProgress = new ModalProgress((Context)host.getActivity());
        }
    }

    @Override
    public void route(Intent intent, Bundle options, int requestCode) {
        if (this.mHost instanceof Activity) {
            ((Activity)this.mHost).startActivityForResult(intent, requestCode, options);
        } else if (this.mHost instanceof androidx.fragment.app.Fragment) {
            ((androidx.fragment.app.Fragment)this.mHost).startActivityForResult(intent, requestCode, options);
        } else if (this.mHost instanceof Fragment) {
            ((Fragment)this.mHost).startActivityForResult(intent, requestCode, options);
        }
    }

    @Override
    public void finish(FinishOptions options) {
        ActivityFinishHelper.finish(this.getActivity(), options);
    }

    @Override
    public void showProgress() {
        if (this.mProgress != null) {
            this.mProgress.showProgress();
        } else if (!this.isActivity() && this.getActivity() instanceof IProgress) {
            ((IProgress)this.getActivity()).showProgress();
        }
    }

    @Override
    public void update(long total, long current, float percent, String tag) {
        if (this.mProgress != null) {
            this.mProgress.update(total, current, percent, tag);
        } else if (!this.isActivity() && this.getActivity() instanceof IProgress) {
            ((IProgress)this.getActivity()).update(total, current, percent, tag);
        }
    }

    @Override
    public void stopProgress() {
        if (this.mProgress != null) {
            this.mProgress.stopProgress();
        } else if (!this.isActivity() && this.getActivity() instanceof IProgress) {
            ((IProgress)this.getActivity()).stopProgress();
        }
    }

    private boolean isActivity() {
        return this.mHost instanceof Activity;
    }

    private Activity getActivity() {
        if (this.mHost instanceof Activity) {
            return (Activity)this.mHost;
        }
        if (this.mHost instanceof androidx.fragment.app.Fragment) {
            return ((androidx.fragment.app.Fragment)this.mHost).getActivity();
        }
        return ((Fragment)this.mHost).getActivity();
    }
}

