package ellax.base.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * created by dongdaqing 19-3-5 下午3:42
 */
public class Md5 {
    /**
     * 对字符串md5加密
     *
     * @param str 被加密的字符串
     * @return 加密后的字符串
     */
    public static String encode(String str) {
        try {
            // 生成一个MD5加密计算摘要
            MessageDigest md = MessageDigest.getInstance("MD5");
            // 计算md5函数
            md.update(str.getBytes());
            return encode(md);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String encode(MessageDigest md) {
        // digest()最后确定返回md5 hash值，返回值为8为字符串。因为md5 hash值是16位的hex值，实际上就是8位的字符
        // BigInteger函数则将8位的字符串转换成16位hex值，用字符串来表示；得到字符串形式的hash值
        String encryptStr = new BigInteger(1, md.digest()).toString(16);
        //因为BigInteger.toString(16),会将前面是0的字符去掉，这里补位加0;比如 212121 这个字符串

        if (encryptStr.length() < 32) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < 32 - encryptStr.length(); i++) {
                buffer.append("0");
            }
            buffer.append(encryptStr);
            return buffer.toString();
        } else {
            return encryptStr;
        }
    }

    //计算文件MD5
    public static String encodeFile(File file) {
        try {
            byte[] buffer = new byte[8192];
            int len;
            MessageDigest md = MessageDigest.getInstance("MD5");
            FileInputStream fis = new FileInputStream(file);
            while ((len = fis.read(buffer)) != -1) {
                md.update(buffer, 0, len);
            }
            fis.close();
            return encode(md);
        } catch (NoSuchAlgorithmException | IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    //计算文件MD5
    public static String encodeFile(String path) {
        return encodeFile(new File(path));
    }
}
