package ellax.base.mvi

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import androidx.viewbinding.ViewBinding
import ellax.base.EllaBaseActivity
import ellax.base.IBaseView
import ellax.base.transition.TransitionHelper.setContentView
import java.lang.reflect.ParameterizedType

/**
 * Date: 2023/4/25 13:53
 * Author: funaihui@ellabook.cn
 * Describe: MVI架构的Activity
 **/
open class BaseMVIActivity<T : ViewBinding> : EllaBaseActivity(), IBaseView {

    protected lateinit var binding: T

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        initViewBinding()
        // 业务view
        initView()
        // 初始化数据
        initData()
        // 初始化viewModel，处理view显示
        initViewModel()
        // 绑定事件监听
        initListener()
    }

    private fun initViewBinding() {
        val type = javaClass.genericSuperclass
        if (type is ParameterizedType) {
            val clazz = type.actualTypeArguments[0] as Class<T>
            val method = clazz.getMethod("inflate", LayoutInflater::class.java)
            binding = method.invoke(null, layoutInflater) as T
            setContentView(binding.root)
        }
    }
}