package ellax.base.helper;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Looper;
import androidx.annotation.StringRes;
import android.view.Gravity;
import android.widget.Toast;

/**
 * Created by dongdaqing on 2017/11/15.
 * 全局Toast，简化调用，在{@link Application}的{@link Application#onCreate()}方法里
 * 调用{@link #setup(Context)}方法进行初始化
 */

public class ToastHelper {
    private static ToastHelper sToast;

    private Context mContext;
    private ToastRunnable mShortToast;
    private ToastRunnable mLongToast;
    private ToastCenterRunnable mShortCenterToast;

    private ToastHelper(Context context) {
        if (context instanceof Application) {
            mContext = context;
        } else {
            mContext = context.getApplicationContext();
        }
    }

    public static void setup(Context context) {
        if (sToast == null) {
            synchronized (ToastHelper.class) {
                if (sToast == null) {
                    sToast = new ToastHelper(context);
                }
            }
        }
    }

    @SuppressLint("ShowToast")
    public static void showToast(String str) {
        if (sToast.mShortToast == null) {
            sToast.mShortToast = new ToastRunnable(Toast.LENGTH_SHORT);
        }
        sToast.mShortToast.setText(str);
        show(sToast.mShortToast);
    }

    @SuppressLint("ShowToast")
    public static void showToast(@StringRes int res) {
        showToast(sToast.mContext.getString(res));
    }

    @SuppressLint("ShowToast")
    public static void showLongToast(String str) {
        if (sToast.mLongToast == null) {
            sToast.mLongToast = new ToastRunnable(Toast.LENGTH_LONG);
        }
        sToast.mLongToast.setText(str);
        show(sToast.mLongToast);
    }

    @SuppressLint("ShowToast")
    public static void showLongToast(@StringRes int res) {
        showLongToast(sToast.mContext.getString(res));
    }

    public static void showCenterToast(String str) {
        if (sToast.mShortCenterToast == null) {
            sToast.mShortCenterToast = new ToastCenterRunnable(Toast.LENGTH_SHORT);
        }
        sToast.mShortCenterToast.setText(str);
        showCenter(sToast.mShortCenterToast);
    }

    private static void show(Runnable runnable) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            runnable.run();
        } else {
            AppExecutors.mainThread(runnable);
        }
    }

    private static void showCenter(ToastCenterRunnable runnable) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            runnable.run();
        } else {
            AppExecutors.mainThread(runnable);
        }
    }

    @SuppressLint("ShowToast")
    private static class ToastRunnable implements Runnable {
        private Toast mToast;
        private String text;
        private int duration;

        public ToastRunnable(int duration) {
            this.duration = duration;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            if (sToast == null)
                throw new RuntimeException("ToastUtil has not been initialized");

            if (mToast == null || (mToast.getView() != null && mToast.getView().isShown())) {
                mToast = Toast.makeText(sToast.mContext, null, duration);
            }
            mToast.setText(text);
            mToast.show();
        }
    }

    @SuppressLint("ShowCenterToast")
    private static class ToastCenterRunnable implements Runnable {
        private Toast mToast;
        private String text;
        private int duration;

        public ToastCenterRunnable(int duration) {
            this.duration = duration;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            if (sToast == null)
                throw new RuntimeException("ToastUtil has not been initialized");

            if (mToast == null || (mToast.getView() != null && mToast.getView().isShown())) {
                mToast = Toast.makeText(sToast.mContext, null, duration);
            }
            mToast.setGravity(Gravity.CENTER, 0, 0);
            mToast.setText(text);
            mToast.show();
        }
    }
}
