package ellax.base.error;

import android.util.SparseArray;

/**
 * Created by dongdaqing on 2018/4/2.
 * 应用里面所有错误的大分类
 */
public class ErrorTypes {
    public static final int UNKNOWN_ERROR = -0001;//未知错误
    //数据错误
    public static final int DEFAULT_ERROR = -1100;//默认类型
    public static final int QUERY_PARAMS_ERROR = -1200;//请求参数出错，用于本地业务逻辑
    public static final int PARSE_FAILED = -1300;//服务端传过来的数据，客户端无法解析或者解析失败
    public static final int NOT_FOUND = -1400;//404，请求的接口找不到
    //客户端向服务端发起请求，服务端返回业务错误
    public static final int BUSINESS_ERROR = -2000;//服务端返回的请求失败
    //列表数据为空
    public static final int NO_DATA = -3000;//请求列表，但是返回的列表为空（这里请求是成功的，只是该列表没有数据，否则就是 BUSINESS_ERROR）

    public static final int SESSION_TIME_OUT = -4000;//登陆信息过期

    //服务出错，网络问题等，以下都可以被归类为网络错误
    public static final int TIME_OUT = -5000;//连接超时
    public static final int UNKNOWN_HOST = -5100;//dns解析失败
    public static final int NETWORK_ERROR = -5200;//网络出错
    public static final int SERVER_ERROR = -5300;//服务器出错，一般是500
    //服务器宕机
    public static final int NO_ROUTE_TO_HOST_ERROR = -5400;

    private static final SparseArray<String> errorMsg = new SparseArray<>();

    static {
        errorMsg.put(UNKNOWN_ERROR, "未知错误");
        errorMsg.put(DEFAULT_ERROR, "操作失败");
        errorMsg.put(QUERY_PARAMS_ERROR, "请求参数出错");
        errorMsg.put(PARSE_FAILED, "数据无法解析");
        errorMsg.put(NO_DATA, "暂无数据");
        errorMsg.put(NOT_FOUND, "请求的数据或者接口找不到");
        errorMsg.put(BUSINESS_ERROR, "返回出错");
        errorMsg.put(SESSION_TIME_OUT, "会话过期,请重新登录");

        errorMsg.put(TIME_OUT, "网络堵车了，好慢...");
        errorMsg.put(UNKNOWN_HOST, "哎哟～断网了哦");
        errorMsg.put(NETWORK_ERROR, "哎哟～断网了哦");
        errorMsg.put(SERVER_ERROR, "服务异常");
        errorMsg.put(NO_ROUTE_TO_HOST_ERROR, "服务端繁忙");
    }

    public static String getMsg(int errorCode) {
        return errorMsg.get(errorCode);
    }

    public static void setMessage(int type, String message) {
        errorMsg.put(type, message);
    }
}
