package ellax.base.error;

/**
 * Created by dongdaqing on 2018/4/2.
 * 业务逻辑错误
 */
public class BusinessError extends Error {
    private String busiCode;//业务逻辑返回的错误代码

    public BusinessError(String busiCode, String message) {
        this(busiCode, message, null);
    }

    /**
     * @param busiCode 服务端返回的业务逻辑出错的代码
     * @param message  服务端返回的业务逻辑出错的消息
     * @param data     这里可以传入服务端返回的完整字符串以方便后续处理
     */
    public BusinessError(String busiCode, String message, Object data) {
        super(ErrorTypes.BUSINESS_ERROR, message, data);
        this.busiCode = busiCode;
    }

    public void setBusiCode(String busiCode) {
        this.busiCode = busiCode;
    }

    public String getBusiCode() {
        return busiCode;
    }
}
