package ellax.base;

import android.app.Activity;
import androidx.fragment.app.Fragment;
import ellax.base.transition.Transition;
import ellax.base.transition.TransitionManager;
import ellax.base.util.ProgressAdapter;

/**
 * created by dongdaqing 19-3-16 下午4:24
 */
final class TransitionProgress extends ProgressAdapter {

    private int key;
    private ModalProgress mModalProgress;

    TransitionProgress(Activity activity) {
        mModalProgress = new ModalProgress(activity);
        key = activity.hashCode();
    }

    TransitionProgress(Fragment fragment) {
        mModalProgress = new ModalProgress(fragment.getActivity());
        key = fragment.hashCode();
    }

    @Override
    public void showProgress() {
        if (!TransitionManager.notifyPageStateChange(key, Transition.STATE_LOADING)) {
            mModalProgress.showProgress();
        }
    }

    @Override
    public void stopProgress() {
        TransitionManager.notifyPageStateChange(key, Transition.STATE_NORMAL);
        mModalProgress.stopProgress();
    }
}
