package ellax.base;

import android.app.Activity;
import android.content.Intent;

/**
 * created by dongdaqing 2018-06-29 18:15
 */
public class FinishOptions {
    private boolean forward;
    private int code;
    private Intent data;
    private boolean transition;//是否等待transition动画完毕

    private FinishOptions() {
        forward = true;
    }

    public static FinishOptions FINISH() {
        FinishOptions options = new FinishOptions();
        options.forward = false;
        return options;
    }

    public static FinishOptions FORWARD_RESULT() {
        FinishOptions options = new FinishOptions();
        options.code = Activity.RESULT_OK;
        return options;
    }

    public static FinishOptions FORWARD_RESULT(Intent intent) {
        return FORWARD_RESULT(Activity.RESULT_OK, intent);
    }

    public static FinishOptions FORWARD_RESULT(int code, Intent intent) {
        FinishOptions options = new FinishOptions();
        options.code = code;
        options.data = intent;
        return options;
    }

    public FinishOptions setTransition(boolean transition) {
        this.transition = transition;
        return this;
    }

    public boolean isTransition() {
        return transition;
    }

    public boolean isForward() {
        return forward;
    }

    public int getCode() {
        return code;
    }

    public Intent getData() {
        return data;
    }
}
