package ellax.base;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import ellax.base.transition.TransitionManager;

/**
 * created by dongdaqing 19-2-27 下午2:47
 */
class BaseDelegate implements IRouteDelegate, IProgress {

    private Object mHost;
    private IProgress mProgress;

    BaseDelegate(Activity host, IProgress progress) {
        mHost = host;
        mProgress = progress;

        if (mProgress == null) {
            if (TransitionManager.transitionEnabled(mHost)) {
                mProgress = new TransitionProgress(host);
            } else {
                mProgress = new ModalProgress(host);
            }
        }
    }

    BaseDelegate(Fragment host, IProgress progress) {
        mHost = host;
        mProgress = progress;

        if (mProgress == null) {
            if (TransitionManager.transitionEnabled(mHost)) {
                mProgress = new TransitionProgress(host);
            } else {
                mProgress = new ModalProgress(host.getActivity());
            }
        }
    }

    BaseDelegate(android.app.Fragment host, IProgress progress) {
        mHost = host;
        mProgress = progress;

        if (mProgress == null) {
            mProgress = new ModalProgress(host.getActivity());
        }
    }

    @Override
    public void route(Intent intent, Bundle options, int requestCode) {
        if (mHost instanceof Activity) {
            ((Activity) mHost).startActivityForResult(intent, requestCode, options);
        } else if (mHost instanceof Fragment)
            ((Fragment) mHost).startActivityForResult(intent, requestCode, options);
        else if (mHost instanceof android.app.Fragment)
            ((android.app.Fragment) mHost).startActivityForResult(intent, requestCode, options);
    }

    @Override
    public void finish(FinishOptions options) {
        ActivityFinishHelper.finish(getActivity(), options);
    }

    @Override
    public void showProgress() {
        if (mProgress != null)
            mProgress.showProgress();
        else if (!isActivity() && getActivity() instanceof IProgress) {
            ((IProgress) getActivity()).showProgress();
        }
    }

    @Override
    public void update(long total, long current, float percent, String tag) {
        if (mProgress != null)
            mProgress.update(total, current, percent, tag);
        else if (!isActivity() && getActivity() instanceof IProgress) {
            ((IProgress) getActivity()).update(total, current, percent, tag);
        }
    }

    @Override
    public void stopProgress() {
        if (mProgress != null)
            mProgress.stopProgress();
        else if (!isActivity() && getActivity() instanceof IProgress) {
            ((IProgress) getActivity()).stopProgress();
        }
    }

    private boolean isActivity() {
        return mHost instanceof Activity;
    }

    private Activity getActivity() {
        if (mHost instanceof Activity)
            return (Activity) mHost;
        else if (mHost instanceof Fragment)
            return ((Fragment) mHost).getActivity();
        return ((android.app.Fragment) mHost).getActivity();
    }
}
