/*
 * Decompiled with CFR 0.152.
 */
package com.commons.utils;

import com.alibaba.fastjson.JSONObject;
import com.commons.constant.ConstantUtil;
import com.commons.utils.Md5Util;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SignAuthUtil {
    private static TreeMap<String, String> signToMap(String userSign) {
        if (StringUtils.isBlank((CharSequence)userSign)) {
            return null;
        }
        String[] signArr = userSign.split("&");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < signArr.length; ++i) {
            String[] params = signArr[i].split("=");
            if (params.length != 2) continue;
            treeMap.put(params[0], params[1]);
        }
        return treeMap;
    }

    public static Map jsonToMap(String jsonStr) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        return (Map)JSONObject.parseObject((String)jsonStr, Map.class);
    }

    public static Map<String, String> paramsCheck(Map<String, String> paramsMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>(1);
        boolean checkAppKey = SignAuthUtil.checkAppKey(paramsMap.get("appKey"));
        if (!checkAppKey) {
            resultMap.put("error", "appKey\u4e0d\u80fd\u4e3a\u7a7a");
            return resultMap;
        }
        boolean checkNonce = SignAuthUtil.checkNonce(paramsMap.get("noncestr"));
        if (!checkNonce) {
            resultMap.put("error", "noncestr\u4e0d\u80fd\u4e3a\u7a7a");
            return resultMap;
        }
        Map<String, String> timestampVerifyMap = SignAuthUtil.verifyTimestamp(paramsMap.get("timestamp"));
        if (MapUtils.isNotEmpty(timestampVerifyMap)) {
            resultMap.put("error", "timestamp" + timestampVerifyMap.get("error"));
            return resultMap;
        }
        return null;
    }

    public static boolean signAuthCheck(Map<String, String> paramsMap, String appSecret) {
        String obj = paramsMap.get("sign");
        if (null == obj) {
            return false;
        }
        String requestSign = String.valueOf(obj);
        paramsMap.remove("sign");
        String sign = SignAuthUtil.createSign(paramsMap, appSecret);
        return requestSign.equalsIgnoreCase(sign);
    }

    public static String createSign(Map map, String appSecret) {
        StringBuffer signBuffer = new StringBuffer();
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(map);
        treeMap.forEach((K, V) -> signBuffer.append(K).append("=").append(V).append("&"));
        signBuffer.append("key=").append(appSecret);
        return Md5Util.Bit32(signBuffer.toString());
    }

    public static String createObjSign(Map<String, Object> map, String appSecret) {
        StringBuffer signBuffer = new StringBuffer();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.putAll(map);
        treeMap.forEach((K, V) -> signBuffer.append((String)K).append("=").append(V).append("&"));
        signBuffer.append("key=").append(appSecret);
        return Md5Util.Bit32(signBuffer.toString());
    }

    private static boolean checkAppKey(String appKey) {
        return !StringUtils.isBlank((CharSequence)appKey);
    }

    private static boolean checkNonce(String nonce) {
        return !StringUtils.isBlank((CharSequence)nonce);
    }

    private static Map<String, String> verifyTimestamp(String timestampStr) {
        HashMap<String, String> verifyMap = new HashMap<String, String>(1);
        boolean checkTimestamp = SignAuthUtil.checkTimestamp(timestampStr);
        if (checkTimestamp) {
            if (!SignAuthUtil.checkTimestampRegex(timestampStr)) {
                verifyMap.put("error", "\u683c\u5f0f\u9519\u8bef");
            } else {
                boolean between;
                if (timestampStr.length() == 10) {
                    timestampStr = timestampStr + "000";
                }
                Long timestamp = Long.parseLong(timestampStr);
                Long nowTimestamp = System.currentTimeMillis();
                boolean bl = between = nowTimestamp - timestamp <= ConstantUtil.SIGN_EXPIRED_TIME;
                if (!between) {
                    verifyMap.put("error", "\u5df2\u5931\u6548\uff0c\u8bf7\u6c42\u65e0\u6548");
                }
            }
        } else {
            verifyMap.put("error", "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return verifyMap;
    }

    private static boolean checkTimestamp(String timestamp) {
        return !StringUtils.isBlank((CharSequence)timestamp);
    }

    private static boolean checkTimestampRegex(String timestamp) {
        String regex = "\\d{13}||\\d{10}";
        boolean isMatch = Pattern.matches(regex, timestamp);
        return isMatch;
    }

    public static void main(String[] args) {
        String requestSign = "{'bookCode':'B201801190032','appKey':'f04e57aaacd8f0c1','noncestr':'" + UUID.randomUUID() + "','timestamp':'" + System.currentTimeMillis() + "'}";
        Map jsonToMap = SignAuthUtil.jsonToMap(requestSign);
        String sign = SignAuthUtil.createSign(jsonToMap, "f6a10ae54a575b3d34df2cd1c693fc93");
        jsonToMap.put("sign", sign);
        System.out.println(JSONObject.toJSONString((Object)jsonToMap).replace("\"", "'"));
    }
}

