/*
 * Decompiled with CFR 0.152.
 */
package com.commons.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    private static volatile HttpUtil instance;
    private static int CONNECT_TIMEOUT;
    private static int READ_TIMEOUT;
    private static int WRITE_TIMEOUT;
    public static final MediaType JSON;
    private static OkHttpClient OkHttpClient;

    private HttpUtil() {
        HttpUtil.init();
    }

    private static void init() {
        HttpUtil.initNormalClient();
    }

    private static void initNormalClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout((long)READ_TIMEOUT, TimeUnit.SECONDS).writeTimeout((long)WRITE_TIMEOUT, TimeUnit.SECONDS).connectTimeout((long)CONNECT_TIMEOUT, TimeUnit.SECONDS);
        OkHttpClient = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtil getInstance() {
        if (instance != null) return instance;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (instance != null) return instance;
            instance = new HttpUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static Headers buildHeaders(Map<String, String> headerMap) {
        Headers.Builder headers = new Headers.Builder();
        if (headerMap != null && !headerMap.isEmpty()) {
            headerMap.forEach((k, v) -> headers.add(k, v));
        }
        return headers.build();
    }

    public static RequestBody buildRequestBody(Map<String, String> bodyMap) {
        FormBody.Builder requestBody = new FormBody.Builder();
        if (bodyMap != null && !bodyMap.isEmpty()) {
            bodyMap.forEach((k, v) -> requestBody.add(k, v));
        }
        return requestBody.build();
    }

    public static Map<String, String> okHttpPostJson(String url, Map<String, String> headerMap, String json) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Headers headers = HttpUtil.buildHeaders(headerMap);
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().method("POST", requestBody).headers(headers).url(url).build();
        try {
            Response response = OkHttpClient.newCall(request).execute();
            if (response.body() != null) {
                resultMap.put("body", response.body().string());
            }
            resultMap.put("code", String.valueOf(response.code()));
            return resultMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return resultMap;
        }
    }

    public static Map<String, String> okHttpPostJson(String url, String json) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().method("POST", requestBody).url(url).build();
        try {
            Response response = OkHttpClient.newCall(request).execute();
            if (response.body() != null) {
                resultMap.put("body", response.body().string());
            }
            resultMap.put("code", String.valueOf(response.code()));
            return resultMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return resultMap;
        }
    }

    public static boolean notifyResponseCheck(Map<String, String> requestResult) {
        if (MapUtils.isNotEmpty(requestResult)) {
            String body = requestResult.get("body");
            String code = requestResult.get("code");
            if (StringUtils.isNotBlank((CharSequence)code) && StringUtils.isNotBlank((CharSequence)body) && "SUCCESS".equalsIgnoreCase(body)) {
                return false;
            }
        }
        return false;
    }

    static {
        CONNECT_TIMEOUT = 60;
        READ_TIMEOUT = 60;
        WRITE_TIMEOUT = 7200;
        JSON = MediaType.parse((String)"application/json; charset=utf-8");
        HttpUtil.init();
    }
}

