/*
 * Decompiled with CFR 0.152.
 */
package com.commons.utils;

import com.commons.entity.dto.OrderListDto;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    public static void createOrderListExcel(HttpServletResponse response, List<OrderListDto> orderList, String fileName, String filePath) {
        try {
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setContentType("application/msexcel");
            String[] titleArr = new String[]{"\u8bbe\u5907\u7801", "\u5e94\u7528\u540d\u79f0", "\u8ba2\u5355\u53f7", "\u5546\u6237\u8ba2\u5355\u53f7", "\u8ba2\u5355\u7c7b\u578b", "\u5546\u54c1\u540d", "\u521b\u5efa\u65f6\u95f4", "\u652f\u4ed8\u65b9\u5f0f", "\u652f\u4ed8\u72b6\u6001", "\u91d1\u989d(\u5143)"};
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("\u8ba2\u5355\u5217\u8868");
            XSSFRow row = sheet.createRow(0);
            sheet.setDefaultColumnWidth(20);
            int colNum = 0;
            if (titleArr.length > 0) {
                for (String title : titleArr) {
                    row.createCell(colNum++).setCellValue(title);
                }
            }
            if (orderList != null && orderList.size() > 0) {
                int rowNum = 1;
                for (OrderListDto order : orderList) {
                    if (order == null) break;
                    row = sheet.createRow(rowNum++);
                    colNum = 0;
                    row.createCell(colNum++).setCellValue(order.getDeviceCode() == null ? "" : order.getDeviceCode());
                    row.createCell(colNum++).setCellValue(order.getAppName() == null ? "" : order.getAppName());
                    row.createCell(colNum++).setCellValue(order.getOrderNo() == null ? "" : order.getOrderNo());
                    row.createCell(colNum++).setCellValue(order.getOrderNo() == null ? "" : order.getTradeNo());
                    row.createCell(colNum++).setCellValue(order.getOrderType() == null ? "" : order.getOrderType());
                    row.createCell(colNum++).setCellValue(order.getGoodsName() == null ? "" : order.getGoodsName());
                    row.createCell(colNum++).setCellValue(order.getCreateTime() == null ? "" : order.getCreateTime().toString());
                    row.createCell(colNum++).setCellValue(order.getPaymentPlatform() == null ? "" : order.getPaymentPlatform());
                    row.createCell(colNum++).setCellValue(order.getOrderStatus() == null ? "" : order.getOrderStatus());
                    row.createCell(colNum++).setCellValue(order.getPayAmount() == null ? "0" : order.getPayAmount().toString());
                }
            }
            FileOutputStream outputStream = new FileOutputStream(filePath + fileName);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            throw new RuntimeException("\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
    }
}

