/*
 * Decompiled with CFR 0.152.
 */
package com.commons.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dozer.DozerBeanMapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanUtils
extends org.springframework.beans.BeanUtils {
    private static DozerBeanMapper dozer = new DozerBeanMapper();

    public static <T> T convert(Object source, Class<T> type) {
        Object target = BeanUtils.instantiateClass(type);
        if (source == null) {
            return (T)target;
        }
        BeanUtils.copyProperties((Object)source, (Object)target);
        return (T)target;
    }

    public static <T> T converts(Object source1, Object source2, Class<T> type) {
        Object target = BeanUtils.instantiateClass(type);
        if (source1 == null && source2 == null) {
            return (T)target;
        }
        BeanUtils.copyProperties((Object)source1, (Object)target);
        BeanUtils.copyProperties((Object)source2, (Object)target);
        return (T)target;
    }

    public static <T> T convert(Object source, Class<T> type, String[] ignoreProperties) {
        Object target = BeanUtils.instantiateClass(type);
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
        return (T)target;
    }

    public static <T, E> List<T> convert(List<E> sources, Class<T> type) {
        ArrayList<T> items = new ArrayList<T>();
        if (sources == null) {
            return items;
        }
        Iterator<E> iter = sources.iterator();
        while (iter.hasNext()) {
            items.add(BeanUtils.convert(iter.next(), type));
        }
        return items;
    }

    public static <T, E> List<T> convert(List<E> sources, Class<T> type, Class<?> editable, String[] ignoreProperties) {
        ArrayList<T> items = new ArrayList<T>();
        if (sources == null) {
            return items;
        }
        Iterator<E> iter = sources.iterator();
        while (iter.hasNext()) {
            items.add(BeanUtils.convert(iter.next(), type, ignoreProperties));
        }
        return items;
    }

    public static void populate(Object bean, Map<String, ?> properties) throws IllegalAccessException, InvocationTargetException {
        org.apache.commons.beanutils.BeanUtils.populate((Object)bean, properties);
    }

    public static Map<?, ?> describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return org.apache.commons.beanutils.BeanUtils.describe((Object)bean);
    }

    public static void copyProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        org.apache.commons.beanutils.BeanUtils.copyProperty((Object)bean, (String)name, (Object)value);
    }

    public static String getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return org.apache.commons.beanutils.BeanUtils.getProperty((Object)bean, (String)name);
    }

    public static <T> T map(Object source, Class<T> destinationClass) {
        return (T)dozer.map(source, destinationClass);
    }

    public static <T, E> List<T> map(List<E> sourceList, Class<T> destinationClass) {
        ArrayList<Object> destinationList = new ArrayList<Object>();
        for (E sourceObject : sourceList) {
            Object destinationObject = dozer.map(sourceObject, destinationClass);
            destinationList.add(destinationObject);
        }
        return destinationList;
    }

    public static void mapProperties(Object source, Object target) {
        dozer.map(source, target);
    }

    public static void copyPropertiesByNames(Object source, Object target, String names) throws BeansException {
        String[] keys;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Assert.hasText((String)names, (String)"names must not be empty");
        for (String name : keys = names.split(",")) {
            name = name.trim();
            PropertyDescriptor targetPd = BeanUtils.getPropertyDescriptor(target.getClass(), (String)name);
            PropertyDescriptor sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)name);
            if (sourcePd == null || sourcePd.getReadMethod() == null || targetPd == null || targetPd.getWriteMethod() == null) continue;
            try {
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy properties from source to target", ex);
            }
        }
    }

    public static Map<String, Object> describe(Object bean, String names) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String[] attrs = StringUtils.split((String)names, (String)",");
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i] = attrs[i].trim();
        }
        return BeanUtils.describe(bean, attrs);
    }

    public static Map<String, Object> describe(Object bean, String[] names) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Assert.notNull((Object)bean, (String)"Source must not be null");
        Assert.notEmpty((Object[])names, (String)"names must not be empty");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String name : names) {
            map.put(name, BeanUtils.getProperty(bean, name));
        }
        return map;
    }
}

