/*
 * Decompiled with CFR 0.152.
 */
package com.commons.utils;

import com.commons.utils.InputStreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Base64Util {
    public static final String UTF_8 = "UTF-8";
    public static final String BIG_5 = "Big5";
    public static final String GBK = "GBK";

    public static String decodeBase64Str(String base64EnCodeString) throws IOException {
        byte[] decode = Base64.getDecoder().decode(base64EnCodeString);
        InputStream inputStream = InputStreamUtil.string2InputStream(decode);
        return InputStreamUtil.inputStream2String(inputStream);
    }

    public static byte[] decodeBase64File(String file) throws IOException {
        String substring = file.substring(0, file.indexOf(44) + 1);
        file = file.replaceAll(substring, "");
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] b = decoder.decodeBuffer(file);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 0) continue;
            int n = i;
            b[n] = (byte)(b[n] + 256);
        }
        return b;
    }

    public static String encodeBASE64(String str) {
        byte[] b = str.getBytes();
        String s = null;
        if (b != null) {
            s = new BASE64Encoder().encode(b);
        }
        return s;
    }

    public static String decodeBase64StrNew(String base64EnCodeString) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)base64EnCodeString)) {
            return "";
        }
        return Base64Util.decodeBase64StrNew(base64EnCodeString, UTF_8);
    }

    public static String decodeBase64StrNew(String base64EnCodeString, String charset) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)base64EnCodeString) || StringUtils.isBlank((CharSequence)charset)) {
            return "";
        }
        byte[] base64decodedBytes = Base64.getDecoder().decode(base64EnCodeString);
        return new String(base64decodedBytes, charset);
    }

    public static String encodeBASE64StrNew(String str) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return Base64Util.encodeBASE64StrNew(str, UTF_8);
    }

    public static String encodeBASE64StrNew(String str, String charset) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((CharSequence)str) || StringUtils.isBlank((CharSequence)charset)) {
            return "";
        }
        return Base64.getEncoder().encodeToString(str.getBytes(charset));
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(Base64Util.encodeBASE64StrNew("    {    \n    \"channelCode\": \"English\", \n    \"clientRole\": \"APP\",   \n    \"clientType\": \"ios\",  \n    \"deviceNo\": \"aaaaa\",  \n    \"resource\": \"iphone5s\" \n    }"));
        System.out.println(Base64Util.encodeBASE64StrNew("    {    \n    \"channelCode\": \"English\", \n    \"clientRole\": \"APP\",   \n    \"clientType\": \"ios\",  \n    \"deviceNo\": \"bbbbb\",  \n    \"resource\": \"iphone5s\" \n    }"));
        System.out.println(Base64Util.encodeBASE64StrNew("    {    \n    \"channelCode\": \"English\", \n    \"clientRole\": \"APP\",   \n    \"clientType\": \"ios\",  \n    \"deviceNo\": \"cccc\",  \n    \"resource\": \"iphone5s\" \n    }"));
        System.out.println(Base64Util.encodeBASE64StrNew("    {    \n    \"channelCode\": \"English\", \n    \"clientRole\": \"APP\",   \n    \"clientType\": \"ios\",  \n    \"deviceNo\": \"dddd\",  \n    \"resource\": \"iphone5s\" \n    }"));
    }
}

