/*
 * Decompiled with CFR 0.152.
 */
package com.commons.utils;

import com.commons.utils.Md5Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;

public class AppSignUtils {
    private static final String SERVER_NAME = "ellacloud";
    private static final String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static String getAppId() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 16; ++i) {
            String str = uuid.substring(i * 2, i * 2 + 2);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString().toLowerCase();
    }

    public static String getAppSecret(String appId) {
        try {
            Object[] array = new String[]{appId, SERVER_NAME, String.valueOf(System.currentTimeMillis())};
            StringBuffer sb = new StringBuffer();
            Arrays.sort(array);
            for (int i = 0; i < array.length; ++i) {
                sb.append((String)array[i]);
            }
            String str = sb.toString();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes());
            byte[] digest = md.digest();
            StringBuffer hexStr = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                String shaHex = Integer.toHexString(digest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexStr.append(0);
                }
                hexStr.append(shaHex);
            }
            return Md5Util.Bit32(hexStr.toString()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] args) {
        String appKey = AppSignUtils.getAppId();
        System.out.println(appKey);
        System.out.println(AppSignUtils.getAppSecret(appKey));
    }
}

