/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.os.Process;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class SaasApp {
    private static Application sApp;

    public static void init(Application app) {
        if (app == null) {
            return;
        }
        if (sApp == null) {
            sApp = app;
            return;
        }
        if (sApp.equals(app)) {
            return;
        }
        sApp = app;
    }

    public static Application getApp() {
        if (sApp != null) {
            return sApp;
        }
        SaasApp.init(SaasApp.getApplicationByReflect());
        if (sApp != null) {
            return sApp;
        }
        throw new NullPointerException("init Application app fail");
    }

    private static Application getApplicationByReflect() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object thread = SaasApp.getActivityThread();
            Object app = activityThreadClass.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                return null;
            }
            return (Application)app;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Object getActivityThread() {
        Object activityThread = SaasApp.getActivityThreadInActivityThreadStaticField();
        if (activityThread != null) {
            return activityThread;
        }
        return SaasApp.getActivityThreadInActivityThreadStaticMethod();
    }

    private static Object getActivityThreadInActivityThreadStaticField() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Field sCurrentActivityThreadField = activityThreadClass.getDeclaredField("sCurrentActivityThread");
            sCurrentActivityThreadField.setAccessible(true);
            return sCurrentActivityThreadField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getActivityThreadInActivityThreadStaticMethod() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            return activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCurrentProcessName() {
        String name = SaasApp.getCurrentProcessNameByFile();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        name = SaasApp.getCurrentProcessNameByAms();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        name = SaasApp.getCurrentProcessNameByReflect();
        return name;
    }

    private static String getCurrentProcessNameByFile() {
        try {
            File file = new File("/proc/" + Process.myPid() + "/cmdline");
            BufferedReader mBufferedReader = new BufferedReader(new FileReader(file));
            String processName = mBufferedReader.readLine().trim();
            mBufferedReader.close();
            return processName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getCurrentProcessNameByAms() {
        try {
            ActivityManager am = (ActivityManager)SaasApp.getApp().getSystemService("activity");
            if (am == null) {
                return "";
            }
            List info = am.getRunningAppProcesses();
            if (info == null || info.size() == 0) {
                return "";
            }
            int pid = Process.myPid();
            for (ActivityManager.RunningAppProcessInfo aInfo : info) {
                if (aInfo.pid != pid || aInfo.processName == null) continue;
                return aInfo.processName;
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    private static String getCurrentProcessNameByReflect() {
        String processName = "";
        try {
            Application app = SaasApp.getApp();
            Field loadedApkField = app.getClass().getField("mLoadedApk");
            loadedApkField.setAccessible(true);
            Object loadedApk = loadedApkField.get(app);
            Field activityThreadField = loadedApk.getClass().getDeclaredField("mActivityThread");
            activityThreadField.setAccessible(true);
            Object activityThread = activityThreadField.get(loadedApk);
            Method getProcessName = activityThread.getClass().getDeclaredMethod("getProcessName", new Class[0]);
            processName = (String)getProcessName.invoke(activityThread, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processName;
    }
}

