/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.style.ImageSpan;
import android.text.style.LeadingMarginSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import cn.ellabook.EllaBookViewerHelper;
import com.ellabook.netwrok.http.EllaHttpService;
import com.ellabook.netwrok.http.HttpServiceCallBack;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.imgspan.ClickableMovementMethod;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.base.util.Converter;
import com.ellabook.project.base.util.ToastUtils;
import com.ellabook.project.ellareader.AudioRecorder;
import com.ellabook.project.ellareader.AudioWordLayout;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ReaderModule;
import com.ellabook.project.ellareader.bean.FeedbackBean;
import com.ellabook.project.ellareader.bean.HttpWordDetails;
import com.ellabook.project.ellareader.biz.BizReader;
import com.ellabook.project.ellareader.ctrl.FeedbackRequestCache;
import com.ellabook.project.ellareader.ui.read.FeedbackPopup;
import com.ellabook.project.ellareader.ui.read.MediaPlayerUtil;
import com.ellabook.project.ellareader.ui.read.SplitedSegmentsLayout;
import com.ellabook.project.ellareader.ui.read.SplitedSentence;
import com.ellabook.project.ellareader.ui.read.SplitedSentencesLayout;
import com.trello.rxlifecycle2.RxLifecycle;
import com.trello.rxlifecycle2.android.FragmentEvent;
import ellax.base.Callback;
import io.reactivex.subjects.BehaviorSubject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SplitedWordDialogFragment
extends DialogFragment
implements SplitedSentencesLayout.OnWordSelectListener {
    private final BehaviorSubject<FragmentEvent> lifecycleSubject = BehaviorSubject.create();
    LinearLayout llRightDes;
    RelativeLayout rlWordLayout;
    ImageView ivWordIcon;
    TextView tvWordTextTip;
    RelativeLayout rlSentenceLayout;
    ImageView ivSentenceIcon;
    TextView tvSentenceTextTip;
    RelativeLayout rlEmptyLayout;
    NestedScrollView nsSentence;
    TextView tvSentenceContent;
    TextView tvSentenceContentTranslate;
    NestedScrollView nsWord;
    TextView tvWord;
    TextView tvAmericaAudio;
    TextView tvEnglandAudio;
    ImageView vLoading;
    ImageView vLoadSentence;
    View maskView;
    RelativeLayout rlReportErrorWord;
    RelativeLayout rlReportErrorSentence;
    AudioWordLayout vWordAudioLayout;
    TextView tvWordDes;
    View tvAddWord;
    SplitedSegmentsLayout splitedSegmentsLayout;
    private int segmentID;
    private int sentenceID;
    private ArrayList<ArrayList<SplitedSentence>> list;
    private String bookCode;
    private String missionCode;
    private String sentenceSpeech;
    private String audioPath;
    private int pageNum;
    private HttpWordDetails httpWordDetails;
    private String mRecorderFilePath = null;
    private String mCurrentSentence;
    private String mCurrentTranslate;
    private String word;
    private String wordTranslate;
    AudioRecorder audioRecorder;

    public static void show(Activity activity, ArrayList<ArrayList<SplitedSentence>> list, int segmentID, int sentenceID, String audioPath, String bookCode, String missionCode, int pageNum) {
        if (list == null || list.isEmpty()) {
            Log.e((String)"split_words", (String)"list empty");
            return;
        }
        if (segmentID >= list.size()) {
            Log.e((String)"split_words", (String)("seg overflow segId" + segmentID + "  list.size " + list.size()));
            segmentID = 0;
        }
        if (list.get(segmentID) == null) {
            Log.e((String)"split_words", (String)("seg overflow sentenceID" + segmentID + " is null"));
            segmentID = -1;
        } else if (sentenceID >= list.get(segmentID).size()) {
            sentenceID = 0;
            Log.e((String)"split_words", (String)("seg overflow sentenceID" + segmentID + "  list.get(segmentID).size " + list.get(segmentID).size()));
        }
        SplitedWordDialogFragment wordModelDialogFragment = new SplitedWordDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("segmentID", segmentID);
        bundle.putInt("sentenceID", sentenceID);
        bundle.putSerializable("splitedSentenceList", list);
        bundle.putString("bookCode", bookCode);
        bundle.putString("audioPath", audioPath);
        bundle.putString("missionCode", missionCode);
        bundle.putInt("pageNum", pageNum);
        wordModelDialogFragment.setArguments(bundle);
        wordModelDialogFragment.setStyle(R.style.full_notch_dialog, 0);
        wordModelDialogFragment.show(activity.getFragmentManager(), "SplitedWordDialogFragment");
    }

    protected void injectView(View view) {
        AnimationDrawable animationDrawable;
        this.llRightDes = (LinearLayout)view.findViewById(R.id.llRightDes);
        this.rlWordLayout = (RelativeLayout)view.findViewById(R.id.rlWordLayout);
        this.ivWordIcon = (ImageView)view.findViewById(R.id.ivWordIcon);
        this.tvWordTextTip = (TextView)view.findViewById(R.id.tvWordTextTip);
        this.rlSentenceLayout = (RelativeLayout)view.findViewById(R.id.rlSentenceLayout);
        this.ivSentenceIcon = (ImageView)view.findViewById(R.id.ivSentenceIcon);
        this.tvSentenceTextTip = (TextView)view.findViewById(R.id.tvSentenceTextTip);
        this.rlEmptyLayout = (RelativeLayout)view.findViewById(R.id.rlEmptyLayout);
        this.nsSentence = (NestedScrollView)view.findViewById(R.id.nsSentence);
        this.tvSentenceContent = (TextView)view.findViewById(R.id.tvSentenceContent);
        this.tvSentenceContentTranslate = (TextView)view.findViewById(R.id.tvSentenceContentTranslate);
        this.nsWord = (NestedScrollView)view.findViewById(R.id.nsWord);
        this.tvWord = (TextView)view.findViewById(R.id.tvWord);
        this.tvAmericaAudio = (TextView)view.findViewById(R.id.tvAmericaAudio);
        this.tvEnglandAudio = (TextView)view.findViewById(R.id.tvEnglandAudio);
        this.vLoading = (ImageView)view.findViewById(R.id.vLoad);
        this.vLoadSentence = (ImageView)view.findViewById(R.id.vLoadSentence);
        this.vWordAudioLayout = (AudioWordLayout)view.findViewById(R.id.vWordAudioLayout);
        this.vWordAudioLayout.setVisibility(8);
        if (this.vLoading.getDrawable() instanceof AnimationDrawable) {
            animationDrawable = (AnimationDrawable)this.vLoading.getDrawable();
            animationDrawable.start();
        }
        if (this.vLoadSentence.getDrawable() instanceof AnimationDrawable) {
            animationDrawable = (AnimationDrawable)this.vLoadSentence.getDrawable();
            animationDrawable.start();
        }
        this.tvWordDes = (TextView)view.findViewById(R.id.tvWordDes);
        this.tvAddWord = view.findViewById(R.id.tvAddWord);
        this.splitedSegmentsLayout = (SplitedSegmentsLayout)view.findViewById(R.id.splitedSegmentsLayout);
        this.maskView = view.findViewById(R.id.fl_content_split);
        this.rlReportErrorSentence = (RelativeLayout)view.findViewById(R.id.rlReportErrorSentence);
        this.rlReportErrorWord = (RelativeLayout)view.findViewById(R.id.rlReportErrorWord);
        view.findViewById(R.id.ivBack).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onBackClick();
            }
        });
        view.findViewById(R.id.rlWordLayout).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onWordSelectClick();
            }
        });
        view.findViewById(R.id.rlSentenceLayout).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onSentenceSelectClick();
            }
        });
        view.findViewById(R.id.tvAddWord).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onAddWordClick();
            }
        });
        view.findViewById(R.id.tvAmericaAudio).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onAmericaAudioClick();
            }
        });
        view.findViewById(R.id.tvEnglandAudio).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SplitedWordDialogFragment.this.onEnglandAudioClick();
            }
        });
        this.vWordAudioLayout.setListener(new AudioWordLayout.RecordListener(){

            @Override
            public void onRecordClick(boolean isRecording) {
                if (isRecording) {
                    SplitedWordDialogFragment.this.stopRecord(true);
                } else {
                    SplitedWordDialogFragment.this.startRecord();
                }
            }

            @Override
            public void onPlayClick() {
                SplitedWordDialogFragment.this.playLastAudio();
            }
        });
        this.tvSentenceContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)SplitedWordDialogFragment.this.sentenceSpeech)) {
                    try {
                        MediaPlayerUtil.play(SplitedWordDialogFragment.this.sentenceSpeech);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.rlReportErrorSentence.setOnClickListener(v -> this.getFeedbackList((View)this.rlReportErrorSentence, this.mCurrentSentence, this.mCurrentTranslate));
        this.rlReportErrorWord.setOnClickListener(v -> {
            if (TextUtils.isEmpty((CharSequence)this.word)) {
                ToastUtils.showToast((String)this.getString(R.string.split_fragment_click_left_words));
                return;
            }
            this.getFeedbackList((View)this.rlReportErrorWord, this.word, this.wordTranslate);
        });
        this.tvAddWord.setVisibility(ReaderModule.isAddWordEnable() ? 0 : 4);
    }

    public void onResume() {
        super.onResume();
    }

    private void getFeedbackList(final View popView, final String word, final String translateResult) {
        final FeedbackRequestCache cache = FeedbackRequestCache.getInstance();
        List<FeedbackBean> list = cache.getReasonListCache(this.bookCode);
        if (list != null) {
            this.showFeedbackPopup(list, popView, word, translateResult);
        } else {
            BizReader.getInstance().getFeedBackList(RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)FragmentEvent.PAUSE), new HttpServiceCallBack<List<FeedbackBean>>(){

                public void onHttpServiceFinished(List<FeedbackBean> result) {
                    SplitedWordDialogFragment.this.showFeedbackPopup(result, popView, word, translateResult);
                    cache.updateReasonList(SplitedWordDialogFragment.this.bookCode, result);
                }

                public void onHttpServiceError(int code, String msg) {
                    ToastUtils.showToast((String)msg);
                }
            });
        }
    }

    private void showFeedbackPopup(final List<FeedbackBean> list, View popView, final String words, final String translateResult) {
        FeedbackPopup popup = new FeedbackPopup();
        popup.setConfirmCallback(new Callback<Integer>(){

            public void callback(Integer integer2) {
                int value = ((FeedbackBean)list.get((int)integer2.intValue())).value;
                String content = ((FeedbackBean)list.get((int)integer2.intValue())).info;
                BizReader.getInstance().commitFeedback(null, value, words, translateResult, SplitedWordDialogFragment.this.bookCode, String.valueOf(SplitedWordDialogFragment.this.pageNum), new HttpServiceCallBack<Object>(){

                    public void onHttpServiceFinished(Object result) {
                        ToastUtils.showToast((int)R.string.feedback_commit_success);
                    }

                    public void onHttpServiceError(int code, String msg) {
                        ToastUtils.showToast((String)msg);
                    }
                });
            }
        });
        popup.show(popView.getContext(), popView, (View)this.llRightDes, list, this.maskView);
    }

    public void onPause() {
        super.onPause();
        this.stopRecord(false);
    }

    private void startRecord() {
        this.vWordAudioLayout.showRecordingUI();
        if (this.audioRecorder == null) {
            this.audioRecorder = new AudioRecorder(new AudioRecorder.OnAudioRecordListener(){

                @Override
                public void onNoVoice() {
                    ToastUtils.showToast((String)"5\u79d2\u5185\u6ca1\u6709\u58f0\u97f3\uff0c\u81ea\u52a8\u5173\u95ed");
                    SplitedWordDialogFragment.this.vWordAudioLayout.hideRecodingUI();
                }

                @Override
                public void onTimeCountDown(long startTime) {
                    SplitedWordDialogFragment.this.vWordAudioLayout.setProgress((int)((System.currentTimeMillis() - startTime) / 1000L), 15);
                }

                @Override
                public void onRecorderOverFlow() {
                    SplitedWordDialogFragment.this.uploadRecorderMP3();
                    ToastUtils.showToast((String)"\u5f55\u97f3\u65f6\u95f4\u6700\u957f\u4e3a15\u79d2");
                    SplitedWordDialogFragment.this.vWordAudioLayout.hideRecodingUI();
                }
            });
        }
        this.audioRecorder.startRecord(new File(this.mRecorderFilePath));
    }

    private void stopRecord(boolean upload) {
        this.vWordAudioLayout.hideRecodingUI();
        if (this.audioRecorder != null) {
            long time = this.audioRecorder.stopRecord();
            if (upload) {
                if (time > 0L) {
                    this.uploadRecorderMP3();
                } else {
                    ToastUtils.showToast((String)"\u8ddf\u8bfb\u58f0\u97f3\u592a\u5c0f");
                }
            }
        }
    }

    private void playLastAudio() {
    }

    private void uploadRecorderMP3() {
        EllaHttpService.getInstance((Context)ApplicationHolder.getContext()).upLoadFile(null, this.mRecorderFilePath, (HttpServiceCallBack)new HttpServiceCallBack<String>(){

            public void onHttpServiceFinished(String s) {
            }

            public void onHttpServiceError(int i, String s) {
            }
        });
    }

    public void onStop() {
        AnimationDrawable animationDrawable;
        super.onStop();
        if (this.vLoading != null && this.vLoading.getDrawable() instanceof AnimationDrawable) {
            animationDrawable = (AnimationDrawable)this.vLoading.getDrawable();
            animationDrawable.stop();
        }
        if (this.vLoadSentence != null && this.vLoadSentence.getDrawable() instanceof AnimationDrawable) {
            animationDrawable = (AnimationDrawable)this.vLoadSentence.getDrawable();
            animationDrawable.stop();
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, R.style.full_notch_dialog);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.getWindow().requestFeature(1);
        if (dialog.getWindow() != null && dialog.getWindow().getDecorView() != null) {
            dialog.getWindow().getDecorView().setSystemUiVisibility(1280);
        }
        return dialog;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_fragment_word_model, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mRecorderFilePath = ApplicationHolder.getContext().getExternalCacheDir().getAbsolutePath() + "/recorder_tmp.mp3";
        this.injectView(view);
        this.segmentID = this.getArguments().getInt("segmentID");
        this.sentenceID = this.getArguments().getInt("sentenceID");
        this.list = (ArrayList)this.getArguments().getSerializable("splitedSentenceList");
        this.audioPath = this.getArguments().getString("audioPath");
        this.bookCode = this.getArguments().getString("bookCode");
        this.missionCode = this.getArguments().getString("missionCode");
        this.pageNum = this.getArguments().getInt("pageNum");
        this.splitedSegmentsLayout.setOnWordSelectListener(this);
        this.splitedSegmentsLayout.setSplitedSentences(this.segmentID, this.sentenceID, this.list);
        this.onSentenceSelectClick();
        this.setSentence(this.splitedSegmentsLayout.getCurrentSplitedSentence().getSentence());
        this.getSentenceInfo(this.splitedSegmentsLayout.getCurrentSplitedSentence().getSentence());
    }

    private void setSentence(String sentence) {
        this.mCurrentSentence = sentence;
        sentence = sentence + "  ";
        String img = "img";
        SpannableString spannableString = new SpannableString((CharSequence)(sentence + img));
        ImageSpan imageSpan = new ImageSpan((Context)this.getActivity(), R.drawable.pass_course_icon_audio, 1);
        spannableString.setSpan((Object)imageSpan, sentence.length(), sentence.length() + img.length(), 17);
        this.tvSentenceContent.setText((CharSequence)spannableString);
        this.tvSentenceContent.setMovementMethod((MovementMethod)ClickableMovementMethod.getInstance());
    }

    @Override
    public void onSelect(int segmentID, int sentenceID, String word, SplitedSentence splitedSentence) {
        this.word = word;
        this.wordTranslate = "";
        this.getWordInfo(word);
        this.getSentenceInfo(splitedSentence.getSentence());
        this.onWordSelectClick();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        try {
            this.getDialog().getWindow().requestFeature(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onActivityCreated(savedInstanceState);
        try {
            this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.getDialog().getWindow().setLayout(-1, -1);
            this.getDialog().getWindow().setFlags(1024, 1024);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onBackClick() {
        this.dismiss();
        EllaBookViewerHelper.resume();
    }

    void onWordSelectClick() {
        this.selectedWord(true);
        this.selectedSentence(false);
    }

    void onSentenceSelectClick() {
        this.selectedSentence(true);
        this.selectedWord(false);
    }

    void onAddWordClick() {
        if (this.word == null) {
            return;
        }
        BizReader.getInstance().addUserWord(RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)FragmentEvent.PAUSE), this.bookCode, this.missionCode, this.pageNum, this.splitedSegmentsLayout.getCurrentSplitedSentence().getSentence(), this.word, this.audioPath, (HttpServiceCallBack)new HttpServiceCallBack<Object>(){

            public void onHttpServiceFinished(Object result) {
                ToastUtils.showToast((String)"\u6dfb\u52a0\u6210\u529f");
            }

            public void onHttpServiceError(int code, String msg) {
                ToastUtils.showToast((String)msg);
            }
        });
    }

    void onAmericaAudioClick() {
        if (this.httpWordDetails == null) {
            return;
        }
        MediaPlayerUtil.play(this.httpWordDetails.usSpeech);
    }

    void onEnglandAudioClick() {
        if (this.httpWordDetails == null) {
            return;
        }
        MediaPlayerUtil.play(this.httpWordDetails.ukSpeech);
    }

    private void selectedWord(boolean isSelected) {
        ViewGroup.LayoutParams layoutParams = this.rlWordLayout.getLayoutParams();
        if (isSelected) {
            this.llRightDes.setBackgroundResource(R.drawable.pass_course_participles_word_selected);
            layoutParams.width = Converter.dip2px((float)this.getResources().getInteger(R.integer.split_word_selected));
            this.rlWordLayout.setLayoutParams(layoutParams);
            this.ivWordIcon.setVisibility(0);
            this.tvWordTextTip.setTextColor(Color.parseColor((String)"#7C70E6"));
            if (TextUtils.isEmpty((CharSequence)this.word)) {
                this.rlEmptyLayout.setVisibility(0);
                this.nsWord.setVisibility(8);
            } else {
                this.rlEmptyLayout.setVisibility(8);
                this.nsWord.setVisibility(0);
            }
        } else {
            this.llRightDes.setBackgroundResource(R.drawable.pass_course_participles_sentence_selected);
            layoutParams.width = Converter.dip2px((float)this.getResources().getInteger(R.integer.split_word_unselected));
            this.rlWordLayout.setLayoutParams(layoutParams);
            this.ivWordIcon.setVisibility(8);
            this.tvWordTextTip.setTextColor(Color.parseColor((String)"#FFFFFF"));
            this.nsWord.setVisibility(8);
        }
    }

    private void selectedSentence(boolean isSelected) {
        ViewGroup.LayoutParams layoutParams = this.rlSentenceLayout.getLayoutParams();
        if (isSelected) {
            layoutParams.width = Converter.dip2px((float)this.getResources().getInteger(R.integer.split_word_selected));
            this.rlSentenceLayout.setLayoutParams(layoutParams);
            this.ivSentenceIcon.setVisibility(0);
            this.tvSentenceTextTip.setTextColor(Color.parseColor((String)"#7C70E6"));
            this.nsSentence.setVisibility(0);
            this.rlEmptyLayout.setVisibility(8);
        } else {
            layoutParams.width = Converter.dip2px((float)this.getResources().getInteger(R.integer.split_word_unselected));
            this.rlSentenceLayout.setLayoutParams(layoutParams);
            this.ivSentenceIcon.setVisibility(8);
            this.tvSentenceTextTip.setTextColor(Color.parseColor((String)"#FFFFFF"));
            this.nsSentence.setVisibility(8);
        }
    }

    private void setFirstLineSpace(TextView tv, float length, String description) {
        SpannableString spannableString = new SpannableString((CharSequence)description);
        int marginSpanSize = Converter.dip2px((float)length);
        LeadingMarginSpan.Standard leadingMarginSpan = new LeadingMarginSpan.Standard(marginSpanSize, 0);
        spannableString.setSpan((Object)leadingMarginSpan, 0, description.length(), 17);
        tv.setText((CharSequence)spannableString);
    }

    private void getSentenceInfo(String sentence) {
        final CharSequence lastSentence = this.tvWord.getText();
        this.setSentence(sentence);
        this.vLoadSentence.setVisibility(0);
        this.tvSentenceContentTranslate.setVisibility(8);
        BizReader.getInstance().getWordDetails(RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)FragmentEvent.PAUSE), UserInfoProvider.getUserId(), sentence, this.bookCode, this.pageNum, new HttpServiceCallBack<HttpWordDetails>(){

            public void onHttpServiceFinished(HttpWordDetails result) {
                SplitedWordDialogFragment.this.setSentence(result.word);
                SplitedWordDialogFragment.this.sentenceSpeech = result.usSpeech;
                SplitedWordDialogFragment.this.mCurrentTranslate = SplitedWordDialogFragment.this.removeWrapper(result.wordDesc);
                SplitedWordDialogFragment.this.vLoadSentence.setVisibility(8);
                SplitedWordDialogFragment.this.tvSentenceContentTranslate.setVisibility(0);
                SplitedWordDialogFragment.this.setFirstLineSpace(SplitedWordDialogFragment.this.tvSentenceContentTranslate, 30.0f, SplitedWordDialogFragment.this.mCurrentTranslate);
            }

            public void onHttpServiceError(int code, String msg) {
                SplitedWordDialogFragment.this.tvSentenceContent.setText(lastSentence);
                ToastUtils.showToast((String)msg);
                SplitedWordDialogFragment.this.vLoadSentence.setVisibility(8);
                SplitedWordDialogFragment.this.tvSentenceContentTranslate.setVisibility(0);
            }
        });
    }

    private void getWordInfo(String word) {
        final String lastWords = this.tvWord.getText().toString();
        this.tvWord.setText((CharSequence)word);
        this.vLoading.setVisibility(0);
        this.tvWordDes.setVisibility(8);
        BizReader.getInstance().getWordDetails(RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)FragmentEvent.PAUSE), UserInfoProvider.getUserId(), word, this.bookCode, this.pageNum, new HttpServiceCallBack<HttpWordDetails>(){

            public void onHttpServiceFinished(HttpWordDetails result) {
                SplitedWordDialogFragment.this.httpWordDetails = result;
                SplitedWordDialogFragment.this.tvWord.setText((CharSequence)result.word);
                SplitedWordDialogFragment.this.wordTranslate = result.explains;
                SplitedWordDialogFragment.this.tvWordDes.setText((CharSequence)SplitedWordDialogFragment.this.removeWrapper(result.explains));
                SplitedWordDialogFragment.this.vLoading.setVisibility(8);
                SplitedWordDialogFragment.this.tvWordDes.setVisibility(0);
            }

            public void onHttpServiceError(int code, String msg) {
                ToastUtils.showToast((String)msg);
                SplitedWordDialogFragment.this.tvWord.setText((CharSequence)lastWords);
                SplitedWordDialogFragment.this.vLoading.setVisibility(8);
                SplitedWordDialogFragment.this.tvWordDes.setVisibility(0);
            }
        });
    }

    private String removeWrapper(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        return s.replace("[", "").replace("]", "").replace("\"", "").replace(",", "\n");
    }
}

