/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ui.read.SplitedSentence;
import com.google.android.material.internal.FlowLayout;
import java.util.List;

public class SplitedSentencesLayout
extends FlowLayout {
    private OnWordSelectListener listener;
    private int segmentId;
    private int currentSentenceIndex;
    private List<SplitedSentence> splitedSentences;
    private int selectWordIndex = -1;

    public SplitedSentencesLayout(Context context) {
        super(context);
    }

    public SplitedSentencesLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SplitedSentencesLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public SplitedSentence getCurrentSplitedSentence() {
        return this.splitedSentences.get(this.currentSentenceIndex);
    }

    public void setOnWordSelectListener(OnWordSelectListener listener) {
        this.listener = listener;
    }

    public void setSplitedSentences(int segmentId, int currentSentenceIndex, List<SplitedSentence> splitedSentences) {
        this.segmentId = segmentId;
        this.currentSentenceIndex = currentSentenceIndex;
        this.splitedSentences = splitedSentences;
        this.updateView();
    }

    private void updateView() {
        if (this.splitedSentences == null) {
            return;
        }
        this.removeAllViews();
        int i = 0;
        for (SplitedSentence splitedSentence : this.splitedSentences) {
            for (String word : splitedSentence.wordList) {
                TextView child = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.item_splited_word, (ViewGroup)this, false);
                this.addView((View)child);
                child.setOnClickListener((View.OnClickListener)new ItemClickListener(i, splitedSentence, word));
                child.setText((CharSequence)word);
                ++i;
            }
        }
        this.updateAllBackGround();
    }

    private void updateAllBackGround() {
        int i = 0;
        for (SplitedSentence splitedSentence : this.splitedSentences) {
            for (String word : splitedSentence.wordList) {
                this.updateItemBackGround((TextView)this.getChildAt(i), splitedSentence, word, i);
                ++i;
            }
        }
    }

    private void updateItemBackGround(TextView textView, SplitedSentence splitedSentence, String word, int index) {
        if (!this.isCurrentSentence(splitedSentence)) {
            textView.setBackgroundResource(R.drawable.bg_word_grey);
            textView.setTextColor(Color.parseColor((String)"#80FFFFFF"));
        } else if (SplitedSentence.isMark(word)) {
            textView.setBackgroundResource(R.drawable.bg_word_grey);
            textView.setTextColor(Color.parseColor((String)"#80FFFFFF"));
        } else if (index == this.selectWordIndex) {
            textView.setBackgroundResource(R.drawable.bg_word_blue);
            textView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.white));
        } else {
            textView.setBackgroundResource(R.drawable.bg_word_white);
            textView.setTextColor(Color.parseColor((String)"#4A4A4A"));
        }
    }

    private boolean isCurrentSentence(SplitedSentence splitedSentence) {
        if (this.currentSentenceIndex < 0 || this.currentSentenceIndex >= this.splitedSentences.size()) {
            return false;
        }
        return splitedSentence == this.splitedSentences.get(this.currentSentenceIndex);
    }

    static interface OnWordSelectListener {
        public void onSelect(int var1, int var2, String var3, SplitedSentence var4);
    }

    class ItemClickListener
    implements View.OnClickListener {
        private int index;
        private SplitedSentence splitedSentence;
        private String word;

        public ItemClickListener(int index, SplitedSentence splitedSentence, String word) {
            this.index = index;
            this.splitedSentence = splitedSentence;
            this.word = word;
        }

        public void onClick(View v) {
            if (SplitedSentence.isMark(this.word)) {
                return;
            }
            SplitedSentencesLayout.this.selectWordIndex = this.index;
            for (int i = 0; i < SplitedSentencesLayout.this.splitedSentences.size(); ++i) {
                if (SplitedSentencesLayout.this.splitedSentences.get(i) != this.splitedSentence) continue;
                SplitedSentencesLayout.this.currentSentenceIndex = i;
                break;
            }
            SplitedSentencesLayout.this.updateAllBackGround();
            if (SplitedSentencesLayout.this.listener != null) {
                SplitedSentencesLayout.this.listener.onSelect(SplitedSentencesLayout.this.segmentId, SplitedSentencesLayout.this.currentSentenceIndex, this.word, this.splitedSentence);
            }
        }
    }
}

