/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.text.TextUtils;
import cn.ellabook.SplitedSentences;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SplitedSentence
implements Serializable {
    public float startPos;
    public float endPos;
    public List<String> wordList;

    public static ArrayList<ArrayList<SplitedSentence>> toLocalListSentence(Object[] splitedSegments) {
        ArrayList<ArrayList<SplitedSentence>> result = new ArrayList<ArrayList<SplitedSentence>>();
        ArrayList<SplitedSentence> temp = new ArrayList<SplitedSentence>();
        if (splitedSegments == null) {
            return result;
        }
        temp = new ArrayList();
        for (Object object : splitedSegments) {
            if (!(object instanceof SplitedSentences)) continue;
            SplitedSentences sentences = (SplitedSentences)object;
            SplitedSentence splitedSentence = new SplitedSentence();
            splitedSentence.startPos = sentences.startPos;
            splitedSentence.endPos = sentences.endPos;
            splitedSentence.wordList = new ArrayList<String>();
            if (sentences.vFont == null) continue;
            for (String vFont : sentences.vFont) {
                if (" ".equals(vFont)) continue;
                splitedSentence.wordList.add(vFont);
            }
            temp.add(splitedSentence);
        }
        result.add(temp);
        return result;
    }

    public static ArrayList<ArrayList<SplitedSentence>> toLocalList(Object[] splitedSegments) {
        ArrayList<ArrayList<SplitedSentence>> result = new ArrayList<ArrayList<SplitedSentence>>();
        ArrayList<SplitedSentence> temp = new ArrayList<SplitedSentence>();
        if (splitedSegments == null) {
            return result;
        }
        for (Object splitedSegment : splitedSegments) {
            Object[] splitedSentences = (Object[])splitedSegment;
            if (splitedSentences == null || splitedSentences.length < 1) continue;
            temp = new ArrayList();
            for (Object object : splitedSentences) {
                if (!(object instanceof SplitedSentences)) continue;
                SplitedSentences sentences = (SplitedSentences)object;
                SplitedSentence splitedSentence = new SplitedSentence();
                splitedSentence.startPos = sentences.startPos;
                splitedSentence.endPos = sentences.endPos;
                splitedSentence.wordList = new ArrayList<String>();
                if (sentences.vFont == null) continue;
                for (String vFont : sentences.vFont) {
                    if (" ".equals(vFont)) continue;
                    splitedSentence.wordList.add(vFont);
                }
                temp.add(splitedSentence);
            }
            result.add(temp);
        }
        return result;
    }

    public String getSentence() {
        if (this.wordList == null || this.wordList.size() == 0) {
            return "";
        }
        if (this.wordList.size() == 1) {
            return this.wordList.get(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.wordList.get(0));
        for (int i = 1; i < this.wordList.size(); ++i) {
            if (!SplitedSentence.isMark(this.wordList.get(i)) && !SplitedSentence.isMark(this.wordList.get(i - 1))) {
                sb.append(" ");
            }
            sb.append(this.wordList.get(i));
        }
        return sb.toString();
    }

    public static boolean isMark(String word) {
        if (TextUtils.isEmpty((CharSequence)word)) {
            return true;
        }
        word = word.trim();
        String replaced = word.replaceAll("\\p{P}|\\p{S}|\\p{C}|\\p{N}|\\p{Z}", "");
        return TextUtils.isEmpty((CharSequence)replaced);
    }
}

