/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ui.read.SplitedSentence;
import com.ellabook.project.ellareader.ui.read.SplitedSentencesLayout;
import java.util.ArrayList;

public class SplitedSegmentsLayout
extends LinearLayout
implements SplitedSentencesLayout.OnWordSelectListener {
    private int currentSegmentIndex;
    private int currentSentenceIndex;
    private ArrayList<ArrayList<SplitedSentence>> splitedSentences;
    private SplitedSentencesLayout.OnWordSelectListener listener;

    public SplitedSegmentsLayout(Context context) {
        super(context);
        this.init();
    }

    public SplitedSegmentsLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SplitedSegmentsLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public SplitedSegmentsLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setOrientation(1);
    }

    public void setSplitedSentences(int currentSegmentIndex, int currentSentenceIndex, ArrayList<ArrayList<SplitedSentence>> splitedSentences) {
        this.currentSegmentIndex = currentSegmentIndex;
        this.currentSentenceIndex = currentSentenceIndex;
        this.splitedSentences = splitedSentences;
        this.updateView(true);
    }

    public void updateView(boolean sentencesChanged) {
        SplitedSentencesLayout splitedSentencesLayout;
        int i;
        if (sentencesChanged) {
            this.removeAllViews();
            for (i = 0; i < this.splitedSentences.size(); ++i) {
                splitedSentencesLayout = (SplitedSentencesLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.splited_setence_layout, (ViewGroup)this, false);
                splitedSentencesLayout.setOnWordSelectListener(this);
                this.addView((View)splitedSentencesLayout, -1, -2);
            }
        }
        for (i = 0; i < this.getChildCount(); ++i) {
            splitedSentencesLayout = (SplitedSentencesLayout)this.getChildAt(i);
            ArrayList<SplitedSentence> sentences = this.splitedSentences.get(i);
            splitedSentencesLayout.setSplitedSentences(i, this.currentSegmentIndex == i ? this.currentSentenceIndex : -1, sentences);
        }
    }

    public SplitedSentence getCurrentSplitedSentence() {
        return this.splitedSentences.get(this.currentSegmentIndex).get(this.currentSentenceIndex);
    }

    public void setOnWordSelectListener(SplitedSentencesLayout.OnWordSelectListener listener) {
        this.listener = listener;
    }

    @Override
    public void onSelect(int segmentId, int sentenceIndex, String word, SplitedSentence splitedSentence) {
        this.currentSegmentIndex = segmentId;
        this.currentSentenceIndex = sentenceIndex;
        this.updateView(false);
        if (this.listener != null) {
            this.listener.onSelect(segmentId, sentenceIndex, word, splitedSentence);
        }
    }
}

