/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;

public class ShadownXorView
extends View {
    RectF mSrcRect;
    RectF mBigRect;
    RectF mSmallRect;
    Paint mPaint;
    Paint mPaintIn;
    float mStart = 0.0f;
    float mEnd = 0.0f;
    float mRadius = 0.0f;
    int storkenWidth = 7;
    private boolean isCircle = true;
    PorterDuffXfermode mXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);

    public void setCircle(float start, float end, float radius) {
        this.isCircle = true;
        this.mStart = start + radius;
        this.mEnd = end + radius;
        this.mRadius = radius;
        this.invalidate();
    }

    public void setCircleCenter(float centerX, float centerY, float radius) {
        this.isCircle = true;
        this.mStart = centerX;
        this.mEnd = centerY;
        this.mRadius = radius;
        this.invalidate();
    }

    public void setRectangle(float x, float y, float w, float h, float radius) {
        this.isCircle = false;
        this.mBigRect = new RectF(x, y, x + w, y + h);
        this.mSmallRect = new RectF(x + (float)this.storkenWidth, y + (float)this.storkenWidth, x + w - (float)this.storkenWidth, y + h - (float)this.storkenWidth);
        this.mRadius = radius;
        this.invalidate();
    }

    public void setStorkenWidth(int storkenWidth) {
        this.storkenWidth = storkenWidth;
    }

    public ShadownXorView(Context context) {
        super(context);
        this.mPaint = new Paint(3);
        this.mPaint.setColor(Color.parseColor((String)"#57effb"));
        this.mPaintIn = new Paint(3);
        this.mPaintIn.setColor(Color.parseColor((String)"#cc000000"));
    }

    public ShadownXorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mPaint = new Paint(3);
        this.mPaint.setColor(Color.parseColor((String)"#57effb"));
        this.mPaintIn = new Paint(3);
        this.mPaintIn.setColor(Color.parseColor((String)"#cc000000"));
    }

    public ShadownXorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint = new Paint(3);
        this.mPaint.setColor(Color.parseColor((String)"#57effb"));
        this.mPaintIn = new Paint(3);
        this.mPaintIn.setColor(Color.parseColor((String)"#cc000000"));
    }

    public ShadownXorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mPaint = new Paint(3);
        this.mPaint.setColor(Color.parseColor((String)"#57effb"));
        this.mPaintIn = new Paint(3);
        this.mPaintIn.setColor(Color.parseColor((String)"#cc000000"));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int saveCount = canvas.saveLayer(this.mSrcRect, this.mPaint, 31);
        canvas.drawRect(this.mSrcRect, this.mPaintIn);
        if (this.isCircle) {
            canvas.drawCircle(this.mStart, this.mEnd, this.mRadius, this.mPaint);
        } else {
            canvas.drawRoundRect(this.mBigRect, this.mRadius, this.mRadius, this.mPaint);
        }
        this.mPaint.setXfermode((Xfermode)this.mXfermode);
        if (this.isCircle) {
            canvas.drawCircle(this.mStart, this.mEnd, this.mRadius - (float)this.storkenWidth, this.mPaint);
        } else {
            canvas.drawRoundRect(this.mSmallRect, this.mRadius, this.mRadius, this.mPaint);
        }
        this.mPaint.setXfermode(null);
        canvas.restoreToCount(saveCount);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mSrcRect = new RectF(0.0f, 0.0f, (float)w, (float)h);
    }
}

