/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.app.Fragment;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import cn.ellabook.EllaBookViewer;
import cn.ellabook.EllaBookViewerHelper;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ui.read.BookReaderActivity;

public class SelfStudyGuideFragment
extends Fragment {
    public static final String GUIDE_KEY = "SelfStudyGuideFragment.GUIDE_KEY";

    public static boolean checkShowGuide(BookReaderActivity context) {
        if (!UserInfoProvider.isGuideAvailable((String)GUIDE_KEY, (boolean)true)) {
            return false;
        }
        EllaBookViewerHelper.pause();
        UserInfoProvider.setGuide((String)GUIDE_KEY, (boolean)false);
        context.getReaderControler().pause();
        SelfStudyGuideFragment courseGuideFragment = new SelfStudyGuideFragment();
        Bundle bundle = new Bundle();
        courseGuideFragment.setArguments(bundle);
        context.getFragmentManager().beginTransaction().replace(R.id.llBookViewControll, (Fragment)courseGuideFragment).commitAllowingStateLoss();
        return true;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_fragment_guide_split_words, container, false);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        view.findViewById(R.id.tvNextThree).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelfStudyGuideFragment.this.dismiss();
            }
        });
        return view;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.playVoice(R.raw.welcome_read_to_learn);
    }

    public boolean isVoiced(String voiceName) {
        if (UserInfoProvider.isGuideAvailable((String)voiceName, (boolean)false)) {
            return true;
        }
        UserInfoProvider.setGuide((String)voiceName, (boolean)true);
        return false;
    }

    public void onStop() {
        super.onStop();
    }

    public void playVoice(int voiceId) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play((Uri)Uri.parse((String)("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId)));
        }
    }

    private void dismiss() {
        AudioPlayer.stopPlay();
        this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        if (EllaBookViewer.getBookPlayMode() != 4) {
            EllaBookViewer.setBookPlayMode((byte)4);
        }
        EllaBookViewerHelper.resume();
    }
}

