/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ellabook.project.base.util.Converter;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.bean.FeedbackBean;
import ellax.base.Callback;
import java.util.List;

public class FeedbackPopup {
    private FeedbackAdapter mAdapter;
    private Callback<Integer> mCallback;

    public void show(Context context, View belowView, View parentView, List<FeedbackBean> list, final View maskView) {
        LayoutInflater mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        ViewGroup menuView = (ViewGroup)mLayoutInflater.inflate(R.layout.popup_feed_back_choose, null, true);
        final PopupWindow pw = new PopupWindow((View)menuView, -2, -2, true);
        pw.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        pw.setOutsideTouchable(true);
        boolean isTablet = context.getResources().getBoolean(R.bool.is_tablet);
        if (!isTablet) {
            menuView.findViewById(R.id.rlArrowTop).setVisibility(8);
            pw.showAtLocation(parentView, 0x800055, Converter.dip2px((float)20.0f), Converter.dip2px((float)30.0f));
        } else if (this.isSpaceEnough(belowView, 170)) {
            pw.showAsDropDown(belowView, 0, 0);
        } else {
            menuView.findViewById(R.id.rlArrowTop).setVisibility(8);
            pw.showAtLocation(parentView, 0x800055, Converter.dip2px((float)53.0f), Converter.dip2px((float)50.0f));
        }
        pw.update();
        pw.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                maskView.setVisibility(8);
            }
        });
        maskView.setVisibility(0);
        menuView.findViewById(R.id.btConfirm).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                pw.dismiss();
                if (FeedbackPopup.this.mCallback != null) {
                    FeedbackPopup.this.mCallback.callback((Object)FeedbackPopup.this.mAdapter.getCurrentPosition());
                }
            }
        });
        this.initRecylerView(context, (RecyclerView)menuView.findViewById(R.id.rvFeedback), list);
    }

    private boolean isSpaceEnough(View targetView, int needSpace) {
        Context context = targetView.getContext();
        int screenHeight = context.getResources().getDisplayMetrics().heightPixels;
        int[] viewLocation = new int[2];
        targetView.getLocationOnScreen(viewLocation);
        int bottom = viewLocation[1] + targetView.getHeight();
        int restSpace = screenHeight - bottom;
        return restSpace > Converter.dip2px((float)needSpace);
    }

    public void setConfirmCallback(Callback<Integer> callback) {
        this.mCallback = callback;
    }

    private void initRecylerView(Context context, RecyclerView rvFeedback, List<FeedbackBean> list) {
        this.mAdapter = new FeedbackAdapter(list, 0);
        rvFeedback.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, 3));
        rvFeedback.addItemDecoration((RecyclerView.ItemDecoration)new GridSpaceDecoration(3, list.size(), Converter.dip2px((float)6.0f), Converter.dip2px((float)8.0f)));
        rvFeedback.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    private static class GridSpaceDecoration
    extends RecyclerView.ItemDecoration {
        private int lineSpace;
        private int rowSpace;
        private int spanCount;
        private int totalCount;

        public GridSpaceDecoration(int _spanCount, int _totalCount, int _lineSpace, int _rowSpace) {
            this.spanCount = _spanCount;
            this.totalCount = _totalCount;
            this.lineSpace = _lineSpace;
            this.rowSpace = _rowSpace;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            int position = parent.getChildAdapterPosition(view);
            int top = 0;
            int left = 0;
            if (!this.isFirstRow(position)) {
                left = this.rowSpace;
            }
            if (!this.isFirstLine(position)) {
                top = this.lineSpace;
            }
            outRect.left = left;
            outRect.top = top;
        }

        private boolean isLastLine(int position) {
            int lines = this.totalCount / this.spanCount + this.totalCount % this.spanCount == 0 ? 0 : 1;
            return position >= (lines - 1) * this.spanCount;
        }

        private boolean isLastRow(int position) {
            return position % this.spanCount == this.spanCount - 1;
        }

        private boolean isFirstRow(int position) {
            return position % this.spanCount == 0;
        }

        private boolean isFirstLine(int position) {
            return position < this.spanCount;
        }
    }

    private static class FeedbackViewHolder
    extends RecyclerView.ViewHolder {
        public FeedbackViewHolder(@NonNull View itemView) {
            super(itemView);
        }

        public void setItem(String value, boolean isSelect) {
            TextView textView = (TextView)this.itemView;
            textView.setText((CharSequence)value);
            textView.setSelected(isSelect);
        }
    }

    private static class FeedbackAdapter
    extends RecyclerView.Adapter<FeedbackViewHolder> {
        private List<FeedbackBean> mList;
        private int mSelectIndex;

        private FeedbackAdapter(@NonNull List<FeedbackBean> list, int selectPosition) {
            this.mList = list;
            this.mSelectIndex = selectPosition;
        }

        @NonNull
        public FeedbackViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_feedback_reason, parent, false);
            return new FeedbackViewHolder(view);
        }

        public void onBindViewHolder(@NonNull FeedbackViewHolder holder, final int position) {
            holder.setItem(this.mList.get((int)position).info, position == this.mSelectIndex);
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    mSelectIndex = position;
                    this.notifyDataSetChanged();
                }
            });
        }

        public int getItemCount() {
            return this.mList.size();
        }

        public int getCurrentPosition() {
            return this.mSelectIndex;
        }
    }
}

