/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.book.cache;

import android.content.Context;
import android.text.TextUtils;
import com.ellabook.project.ellareader.book.bean.BookExtraInfo;
import com.ellabook.project.ellareader.book.cache.ConcurrentTotalFileSize;
import com.ellabook.project.ellareader.book.cache.EllaDowloadStorageManager;
import com.ellabook.project.ellareader.book.cache.bean.ProfileStorageAll;
import com.ellabook.project.ellareader.book.cache.bean.ProfileStorageItem;
import ellax.bookmanager.BookLocalInfo;
import ellax.bookmanager.BookManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class ConcurrentTotalFileSizeWLatch {
    private List<ProfileStorageItem> list = new ArrayList<ProfileStorageItem>();

    public ProfileStorageAll getTotalSizeOfFile(Context context) throws InterruptedException, ExecutionException, TimeoutException {
        List installedBookInfos = BookManager.getInstalledBooks();
        ProfileStorageAll profileStorageAll = new ProfileStorageAll();
        profileStorageAll.setList(new ArrayList<ProfileStorageItem>());
        if (installedBookInfos != null) {
            for (BookLocalInfo bookLocalInfo : installedBookInfos) {
                ProfileStorageItem item = new ProfileStorageItem();
                BookExtraInfo extraInfo = (BookExtraInfo)BookManager.readExtra((String)bookLocalInfo.bookCode, BookExtraInfo.class);
                if (extraInfo == null) continue;
                File file = BookManager.getResourceInstallDir((String)bookLocalInfo.bookCode, (boolean)false, (boolean)false);
                if (file.exists()) {
                    item.setFilePath(file.getPath());
                }
                if ((file = BookManager.getResourceInstallDir((String)bookLocalInfo.bookCode, (boolean)true, (boolean)false)).exists()) {
                    item.setFilePath(file.getPath());
                }
                item.setName(extraInfo.name);
                long total = new ConcurrentTotalFileSize().getTotalSizeOfFilesInDir(new File(item.getFilePath()));
                item.setItemSize(total);
                item.setShowItemSize(EllaDowloadStorageManager.getInstance(context).getFormatStorageSize(total));
                item.setInfo(extraInfo);
                if ("LESSON".equals(extraInfo.type)) {
                    item.setType(EllaDowloadStorageManager.RESOURCETYPE.LESSON.ordinal());
                    profileStorageAll.getList().add(item);
                    continue;
                }
                if (!"COURSE".equals(extraInfo.type)) continue;
                item.setType(EllaDowloadStorageManager.RESOURCETYPE.COURSE.ordinal());
                profileStorageAll.getList().add(item);
            }
        }
        return profileStorageAll;
    }

    public ProfileStorageAll getTotalSizeOfFile(int level, Context context) throws InterruptedException, ExecutionException, TimeoutException {
        List installedBookInfos = BookManager.getInstalledBooks();
        ProfileStorageAll profileStorageAll = new ProfileStorageAll();
        profileStorageAll.setList(new ArrayList<ProfileStorageItem>());
        if (installedBookInfos != null) {
            for (BookLocalInfo bookLocalInfo : installedBookInfos) {
                ProfileStorageItem item = new ProfileStorageItem();
                BookExtraInfo extraInfo = (BookExtraInfo)BookManager.readExtra((String)bookLocalInfo.bookCode, BookExtraInfo.class);
                if (extraInfo == null || !TextUtils.equals((CharSequence)extraInfo.level, (CharSequence)String.valueOf(level))) continue;
                File file = BookManager.getResourceInstallDir((String)bookLocalInfo.bookCode, (boolean)false, (boolean)false);
                if (file.exists()) {
                    item.setFilePath(file.getPath());
                }
                if ((file = BookManager.getResourceInstallDir((String)bookLocalInfo.bookCode, (boolean)true, (boolean)false)).exists()) {
                    item.setFilePath(file.getPath());
                }
                item.setName(extraInfo.name);
                long total = new ConcurrentTotalFileSize().getTotalSizeOfFilesInDir(new File(item.getFilePath()));
                item.setItemSize(total);
                item.setShowItemSize(EllaDowloadStorageManager.getInstance(context).getFormatStorageSize(total));
                item.setInfo(extraInfo);
                if ("LESSON".equals(extraInfo.type)) {
                    item.setType(EllaDowloadStorageManager.RESOURCETYPE.LESSON.ordinal());
                    profileStorageAll.getList().add(item);
                    continue;
                }
                if (!"COURSE".equals(extraInfo.type)) continue;
                item.setType(EllaDowloadStorageManager.RESOURCETYPE.COURSE.ordinal());
                profileStorageAll.getList().add(item);
            }
        }
        return profileStorageAll;
    }
}

