/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader;

import android.graphics.drawable.AnimationDrawable;
import android.os.Handler;

public class ListenableFrameAnimation
extends AnimationDrawable {
    private Handler handler = new Handler();
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (ListenableFrameAnimation.this.getFrame(ListenableFrameAnimation.this.getNumberOfFrames() - 1) != ListenableFrameAnimation.this.getCurrent()) {
                ListenableFrameAnimation.this.initHandler();
            } else {
                ListenableFrameAnimation.this.unRunning();
            }
        }
    };
    private OnFrameAnimationListener onFrameAnimationListener;
    private int maxDuration;

    private void unRunning() {
        if (this.onFrameAnimationListener != null) {
            this.onFrameAnimationListener.onEnd();
        }
        this.handler.removeCallbacks(this.runnable);
    }

    public void start() {
        super.start();
        this.initHandler();
        if (this.onFrameAnimationListener != null) {
            this.onFrameAnimationListener.onStart();
        }
    }

    private void initHandler() {
        this.handler.postDelayed(this.runnable, this.maxDuration == 0 ? (long)this.getMaxDuration() : (long)this.maxDuration);
    }

    public void stop() {
        super.stop();
    }

    private int getMaxDuration() {
        for (int i = 0; i < this.getNumberOfFrames(); ++i) {
            if (this.maxDuration >= this.getDuration(i)) continue;
            this.maxDuration = this.getDuration(i);
        }
        return this.maxDuration > 1000 ? 1000 : this.maxDuration;
    }

    public void setOnFrameAnimationListener(OnFrameAnimationListener onFrameAnimationListener) {
        this.onFrameAnimationListener = onFrameAnimationListener;
    }

    public static interface OnFrameAnimationListener {
        public void onStart();

        public void onEnd();
    }
}

