/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.RoundProgressBar;

public class AudioWordLayout
extends FrameLayout {
    boolean inited = false;
    private RecordListener listener;
    private View vPlay;
    private ImageView vAnimation;
    private TextView vScore;
    private View vRecording;
    private RoundProgressBar roundProgressBar;
    private Integer score = null;
    private String url = null;

    public void setListener(RecordListener listener) {
        this.listener = listener;
    }

    public AudioWordLayout(@NonNull Context context) {
        super(context);
        this.init();
    }

    public AudioWordLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AudioWordLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public AudioWordLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        if (!this.inited) {
            this.inited = true;
            this.addView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.word_record_layout, (ViewGroup)this, false));
            this.roundProgressBar = (RoundProgressBar)this.findViewById(R.id.vProgress);
            this.vPlay = this.findViewById(R.id.vPlay);
            this.vAnimation = (ImageView)this.findViewById(R.id.vAnimation);
            this.vScore = (TextView)this.findViewById(R.id.vScore);
            this.vRecording = this.findViewById(R.id.vRecording);
            this.vRecording.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AudioWordLayout.this.roundProgressBar.getBackground() != null) {
                        if (AudioWordLayout.this.listener != null) {
                            AudioWordLayout.this.listener.onRecordClick(false);
                        }
                    } else if (AudioWordLayout.this.listener != null) {
                        AudioWordLayout.this.listener.onRecordClick(true);
                    }
                }
            });
        }
    }

    public void showRecordingUI() {
        this.vAnimation.setVisibility(0);
        ((AnimationDrawable)this.vAnimation.getDrawable()).start();
        this.vPlay.setVisibility(4);
        this.vScore.setVisibility(4);
        this.roundProgressBar.setBackground(null);
        this.roundProgressBar.setProgress(0);
    }

    public void hideRecodingUI() {
        this.vAnimation.setVisibility(4);
        ((AnimationDrawable)this.vAnimation.getDrawable()).stop();
        if (this.url != null) {
            this.vPlay.setVisibility(4);
            this.vScore.setVisibility(4);
        }
        this.roundProgressBar.setBackgroundResource(R.drawable.word_recording_progressing_bg);
        this.roundProgressBar.setProgress(0);
    }

    public void setProgress(int time, int max) {
        this.roundProgressBar.setProgress(time);
        this.roundProgressBar.setMax(max);
    }

    public void setScore(Integer score) {
        this.score = score;
        this.vScore.setText((CharSequence)("\u5f97\u5206" + score + "\u5206"));
    }

    public void setUrl(String url) {
        this.url = url;
        this.vPlay.setVisibility(0);
    }

    public static interface RecordListener {
        public void onRecordClick(boolean var1);

        public void onPlayClick();
    }
}

