/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.ui.read;

import android.app.Fragment;
import android.net.Uri;
import android.os.Bundle;
import android.os.Looper;
import android.os.MessageQueue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ellabook.project.base.ApplicationHolder;
import com.ellabook.project.base.media.AudioPlayer;
import com.ellabook.project.base.user.UserInfoProvider;
import com.ellabook.project.ellareader.R;
import com.ellabook.project.ellareader.ui.read.BookReaderActivity;
import com.ellabook.project.ellareader.ui.read.ShadownXorView;

public class CourseGuideFragment
extends Fragment
implements View.OnClickListener {
    private RelativeLayout rlGuideOne;
    private TextView tvNextOne;
    private TextView tvSkipOne;
    private RelativeLayout rlGuideTwo;
    private TextView tvNextTwo;
    private TextView tvSkipTwo;
    private RelativeLayout rlGuideFour;
    private TextView tvNextFour;
    private TextView tvSkipFour;
    private RelativeLayout rlGuideFive;
    private TextView tvLookRepeat;
    private TextView tvGuideDone;
    private View vDiamondHighLight = null;
    private ShadownXorView sdvDiamondHighLight;
    private ShadownXorView sdvEllaReadExit;
    private ShadownXorView sdvEllaReadRight;
    private ShadownXorView sdvEllaReadLeft;
    private View vEllaReadExit;
    private View vEllaReadRight;
    private View vEllaReadLeft;
    public static final String GUIDE_KEY = "CourseGuideFragment.GUIDE_KEY";

    public static boolean checkShowGuide(BookReaderActivity context, int diamondWidth) {
        if (context.getReaderControler().getCurrentPage() != 2) {
            return false;
        }
        if (!UserInfoProvider.isGuideAvailable((String)GUIDE_KEY, (boolean)true)) {
            return false;
        }
        UserInfoProvider.setGuide((String)GUIDE_KEY, (boolean)false);
        context.getReaderControler().pause();
        CourseGuideFragment courseGuideFragment = new CourseGuideFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("diamond_width", diamondWidth);
        courseGuideFragment.setArguments(bundle);
        context.getFragmentManager().beginTransaction().replace(R.id.llBookViewControll, (Fragment)courseGuideFragment).commitAllowingStateLoss();
        return true;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dialog_fragment_guide, container, false);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        int diamondWidth = this.getArguments().getInt("diamond_width");
        this.vDiamondHighLight = view.findViewById(R.id.vDiamondHighLight);
        this.vDiamondHighLight.getLayoutParams().width = diamondWidth;
        this.sdvDiamondHighLight = (ShadownXorView)view.findViewById(R.id.sdvDiamondHighLight);
        this.sdvEllaReadExit = (ShadownXorView)view.findViewById(R.id.sdvEllaReadExit);
        this.vEllaReadExit = view.findViewById(R.id.vEllaReadExit);
        this.sdvEllaReadRight = (ShadownXorView)view.findViewById(R.id.sdvEllaReadRight);
        this.vEllaReadRight = view.findViewById(R.id.vEllaReadRight);
        this.sdvEllaReadLeft = (ShadownXorView)view.findViewById(R.id.sdvEllaReadLeft);
        this.vEllaReadLeft = view.findViewById(R.id.vEllaReadLeft);
        this.rlGuideOne = (RelativeLayout)view.findViewById(R.id.rlGuideOne);
        this.tvNextOne = (TextView)view.findViewById(R.id.tvNextOne);
        this.tvSkipOne = (TextView)view.findViewById(R.id.tvSkipOne);
        this.rlGuideTwo = (RelativeLayout)view.findViewById(R.id.rlGuideTwo);
        this.tvNextTwo = (TextView)view.findViewById(R.id.tvNextTwo);
        this.tvSkipTwo = (TextView)view.findViewById(R.id.tvSkipTwo);
        this.rlGuideFour = (RelativeLayout)view.findViewById(R.id.rlGuideFour);
        this.tvNextFour = (TextView)view.findViewById(R.id.tvNextFour);
        this.tvSkipFour = (TextView)view.findViewById(R.id.tvSkipFour);
        this.rlGuideFive = (RelativeLayout)view.findViewById(R.id.rlGuideFive);
        this.tvLookRepeat = (TextView)view.findViewById(R.id.tvLookRepeat);
        this.tvGuideDone = (TextView)view.findViewById(R.id.tvGuideDone);
        this.tvNextOne.setOnClickListener((View.OnClickListener)this);
        if (this.tvSkipOne != null) {
            this.tvSkipOne.setOnClickListener((View.OnClickListener)this);
        }
        this.tvNextTwo.setOnClickListener((View.OnClickListener)this);
        if (this.tvSkipTwo != null) {
            this.tvSkipTwo.setOnClickListener((View.OnClickListener)this);
        }
        this.tvNextFour.setOnClickListener((View.OnClickListener)this);
        if (this.tvSkipFour != null) {
            this.tvSkipFour.setOnClickListener((View.OnClickListener)this);
        }
        this.tvLookRepeat.setOnClickListener((View.OnClickListener)this);
        this.tvGuideDone.setOnClickListener((View.OnClickListener)this);
        Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)new ShowGuideIdleOnce());
        if (!this.isVoiced("welcome_learn_to_read")) {
            this.playVoice(R.raw.welcome_learn_to_read);
        }
        return view;
    }

    private boolean resetGuide() {
        if (this.vDiamondHighLight == null) {
            return false;
        }
        if (this.vDiamondHighLight.getX() == 0.0f) {
            return true;
        }
        this.sdvDiamondHighLight.setRectangle(this.vDiamondHighLight.getX(), this.vDiamondHighLight.getY(), this.vDiamondHighLight.getWidth(), this.vDiamondHighLight.getHeight(), this.getResources().getDimension(R.dimen.book_reader_diamond_size));
        this.sdvEllaReadExit.setCircle(this.vEllaReadExit.getX(), this.vEllaReadExit.getY(), this.vEllaReadExit.getHeight() / 2);
        this.sdvEllaReadRight.setCircle(this.vEllaReadRight.getX(), this.vEllaReadRight.getY(), this.vEllaReadRight.getHeight() / 2);
        this.sdvEllaReadLeft.setCircle(this.vEllaReadLeft.getX(), this.vEllaReadLeft.getY(), this.vEllaReadLeft.getHeight() / 2);
        return false;
    }

    public void onStop() {
        super.onStop();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tvNextOne) {
            if (!this.isVoiced("course_menu")) {
                this.playVoice(R.raw.course_menu);
            }
            this.rlGuideOne.setVisibility(4);
            this.rlGuideTwo.setVisibility(0);
        } else if (id2 == R.id.tvSkipOne) {
            this.dismiss();
        } else if (id2 == R.id.tvNextTwo) {
            if (!this.isVoiced("course_next_page")) {
                this.playVoice(R.raw.course_menu_next_page);
            }
            this.rlGuideTwo.setVisibility(4);
            this.rlGuideFour.setVisibility(0);
        } else if (id2 == R.id.tvSkipTwo) {
            this.dismiss();
        } else if (id2 == R.id.tvNextFour) {
            if (!this.isVoiced("course_pre_page")) {
                this.playVoice(R.raw.course_menu_pre_page);
            }
            this.rlGuideFour.setVisibility(4);
            this.rlGuideFive.setVisibility(0);
        } else if (id2 == R.id.tvSkipFour) {
            this.dismiss();
        } else if (id2 == R.id.tvLookRepeat) {
            if (!this.isVoiced("welcome_learn_to_read")) {
                this.playVoice(R.raw.welcome_learn_to_read);
            }
            this.rlGuideFive.setVisibility(4);
            this.rlGuideOne.setVisibility(0);
        } else if (id2 == R.id.tvGuideDone) {
            this.dismiss();
        }
    }

    public boolean isVoiced(String voiceName) {
        return false;
    }

    public void playVoice(int voiceId) {
        if (UserInfoProvider.guideVoiceAvailable()) {
            AudioPlayer.play((Uri)Uri.parse((String)("android.resource://" + ApplicationHolder.getContext().getPackageName() + "/" + voiceId)));
        }
    }

    private void dismiss() {
        AudioPlayer.stopPlay();
        this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        ((BookReaderActivity)this.getActivity()).getReaderControler().resume();
    }

    class ShowGuideIdleOnce
    implements MessageQueue.IdleHandler {
        ShowGuideIdleOnce() {
        }

        public boolean queueIdle() {
            if (CourseGuideFragment.this.isDetached()) {
                return false;
            }
            return CourseGuideFragment.this.resetGuide();
        }
    }
}

