/*
 * Decompiled with CFR 0.152.
 */
package cn.ellabook;

public class ReadTimeCounter {
    private long readTime;
    private long startTime;

    public static ReadTimeCounter getInstance() {
        return InstanceHolder.instance;
    }

    private ReadTimeCounter() {
    }

    void onActivityCreate() {
        this.readTime = 0L;
        this.startTime = 0L;
    }

    void onActivityResume() {
        this.startTime = System.currentTimeMillis();
    }

    void onActivityPause() {
        if (this.startTime == 0L) {
            return;
        }
        this.readTime = this.readTime + System.currentTimeMillis() - this.startTime;
        this.startTime = 0L;
    }

    public long getAndClearReadTime() {
        long tempTime = this.readTime;
        if (this.startTime != 0L) {
            tempTime = tempTime + System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }
        this.readTime = 0L;
        return tempTime;
    }

    private static class InstanceHolder {
        private static ReadTimeCounter instance = new ReadTimeCounter();

        private InstanceHolder() {
        }
    }
}

