package com.ellabook.project.ellareader.book.download;

import androidx.fragment.app.FragmentActivity;

import com.ellabook.project.base.tool.Callback;
import com.ellabook.project.ellareader.book.bean.BookContainer;

import ellax.bookmanager.BookManager;

/**
 * created by dongdaqing 2018-08-03 13:50
 */
@Deprecated
public class BookDownloadHelper implements Callback<Boolean> {
    private BookContainer mBook;

    public BookDownloadHelper(BookContainer book) {
        mBook = book;
    }

    public void start(FragmentActivity activity, boolean isNeedCheckOnlyWifi) {
        if (BookManager.isDownloading(mBook)) {
            BookManager.pause(mBook);
            return;
        }

        if (isNeedCheckOnlyWifi) {
            new DownloadHelper(activity, this).start();
        } else {
            new DownloadHelper(activity, this).startByNoCheck();
        }
    }

    public void start(FragmentActivity activity) {
        start(activity, true);
    }

    @Override
    public void callback(Boolean wifi) {
        download(mBook, wifi);
    }

    private void download(BookContainer book, boolean wifi) {
        BookManager.download(book, wifi);
    }
}
