package com.ellabook.project.ellareader.book.cache;


import android.content.Context;


import com.ellabook.project.base.log.EllaLog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;

/**
 * 本地缓存文件的读写操作
 * 要求在后台初始化context
 * Created by java on 2017/7/12.
 */

public class Cache {
    private static class BCacheControlHolder {
        private static Cache INSTANCE = new Cache();
    }

    public static Cache getInstance() {
        return BCacheControlHolder.INSTANCE;
    }

    private Context m_context;
    private Gson m_gson = new GsonBuilder().create();

    public void init(Context context) {
        m_context = context;
    }

    public void write(Object object, String path) {
        try {
            Writer writer = new FileWriter(path);
            if (object != null) {
                m_gson.toJson(object, writer);
                writer.close();
            }
        } catch (Exception e) {
            EllaLog.e("201707121227", e.toString());
        }
    }

    public void write(String object, String path) {
        try {
            Writer writer = new FileWriter(path);
            if (object != null) {
                writer.write(object);
                writer.close();
            }
        } catch (Exception e) {
            EllaLog.e("201707121227", e.toString());
        }
    }

    public <T> T readFileData4Gson(String path, Class<T> classOfT) {
        String res = null;
        try {
            File file = new File(path);
            if (!file.exists())
                return null;
            FileInputStream fin = new FileInputStream(file);
            int length = fin.available();
            byte[] buffer = new byte[length];
            fin.read(buffer);
            res = new String(buffer, "UTF-8");
            fin.close();
            return m_gson.fromJson(res, classOfT);
        } catch (Exception e) {
            EllaLog.e("201709121132", e.toString());
        }
        return null;
    }

    public String readFileData(String path) {
        String res = null;
        try {
            File file = new File(path);
            if (!file.exists())
                return null;
            FileInputStream fin = new FileInputStream(file);
            int length = fin.available();
            byte[] buffer = new byte[length];
            fin.read(buffer);
            res = new String(buffer, "UTF-8");
            fin.close();
        } catch (Exception e) {
            EllaLog.e("201707121459", e.toString());
        }
        return res;
    }

    public Gson getGson() {
        return m_gson;
    }

    public void setGson(Gson m_gson) {
        this.m_gson = m_gson;
    }

    public Context getContext() {
        return m_context;
    }

    public void setContext(Context m_context) {
        this.m_context = m_context;
    }
}
