package com.ellabook.project.ellareader.book;

import android.app.Application;

import com.ellabook.project.ellareader.book.bean.BookContainer;

import ellax.bookmanager.ReaderResource;

/**
 * created by dongdaqing 2018-10-29 16:50
 * <p>
 * 书籍资源管理(试读模式的资源存放地址不在用户目录下)
 */
public interface IBookManager {
    public  void setup(Application app);
    /**
     * 查询书籍是否已安装（这里查询的是书籍的主体资源，不包含伴读资源）
     * <p>
     * 查询本地是否有书籍资源，这里是通过判断资源目录来判断书籍是否存在
     * <p>
     * 标准屏幕（宽高比不大于 16/9）  ==> Iphone1334
     * 全面屏（宽高比大于 16/9）    ==> Iphone2208
     * <p>
     * 2019.01.04补充
     * 有些书籍是没有全面屏资源的，所以判断书籍是否已安装，要去查询用户目录，而不能仅仅根据假定的路径来判断，这样可能会陷入死循环
     *
     * @return
     */
    public  boolean isBookInstalled(String bookCode);

//    public  int getBookStatus(BookContainer bookContainer) ;


    /**
     * 下载书籍（会下载所有不存在的资源）
     *
     * @param book       要下载的书籍
     * @param isOnlyWifi 是否只在WiFi下下载
     * @param tryRead    是否是试读模式
     */
    public  void download(BookContainer book, boolean tryRead, boolean isOnlyWifi) ;

    /**
     * 下载书籍（会下载所有不存在的资源）
     *
     * @param book       要下载的书籍
     * @param isOnlyWifi 是否只在WiFi下下载
     */
    public void download(BookContainer book, boolean isOnlyWifi) ;

    /**
     * 下载资源
     *
     * @param resource   要下载的资源
     * @param isOnlyWifi 是否只在WiFi下下载
     */
    public void download(ReaderResource resource, boolean isOnlyWifi) ;

    /**
     * 暂停图书下载
     *
     * @param book 要暂停的书籍
     */
    public void pause(BookContainer book) ;

    /**
     * 暂停资源下载
     *
     * @param resource 要暂停的资源
     */
    public void pause(ReaderResource resource) ;


    public void pauseAll() ;

    /**
     * 停止正在下载的任务（如果有），卸载书籍（删除书籍存在于本地的所有资源）
     *
     * @param bookContainer
     */
    public void uninstallSync(BookContainer bookContainer) ;


    public boolean isDownloading(BookContainer book) ;

    public boolean isDownloading(ReaderResource resource);
    public  boolean isBookUp2Date(String bookCode, String currentVersion, boolean publicResource);

}
