package com.ellabook.project.ellareader.book;

import android.app.Application;

import com.ellabook.project.ellareader.book.bean.BookContainer;
import com.ellabook.project.ellareader.book.download.BookManagerImpl;

import ellax.bookmanager.ReaderResource;

/**
 * created by dongdaqing 2018-10-29 16:50
 * <p>
 * 书籍资源管理(试读模式的资源存放地址不在用户目录下)
 */
@Deprecated
public class BookManager {
    public static final int ERROR = ellax.bookmanager.BookManager.ERROR;
    public static final int COMPLETED = ellax.bookmanager.BookManager.COMPLETED;
    public static final int PROGRESS = ellax.bookmanager.BookManager.PROGRESS;
    public static final int PAUSED = ellax.bookmanager.BookManager.PAUSED;
    public static final int PENDING = ellax.bookmanager.BookManager.PENDING;
    public static final int NONE = ellax.bookmanager.BookManager.NONE;

    public static final int INSTALLED = ellax.bookmanager.BookManager.UNZIP_END;
    public static final int INSTALLING = ellax.bookmanager.BookManager.UNZIP_START;
    static IBookManager sBookManager;

    public static void init(IBookManager bookManager) {
        sBookManager = bookManager;
    }

    public static void setup(Application app) {
        sBookManager = new BookManagerImpl();
        sBookManager.setup(app);
    }

    /**
     * 查询书籍是否已安装（这里查询的是书籍的主体资源，不包含伴读资源）
     * <p>
     * 查询本地是否有书籍资源，这里是通过判断资源目录来判断书籍是否存在
     * <p>
     * 标准屏幕（宽高比不大于 16/9）  ==> Iphone1334
     * 全面屏（宽高比大于 16/9）    ==> Iphone2208
     * <p>
     * 2019.01.04补充
     * 有些书籍是没有全面屏资源的，所以判断书籍是否已安装，要去查询用户目录，而不能仅仅根据假定的路径来判断，这样可能会陷入死循环
     *
     * @return
     */
    public static boolean isBookInstalled(String bookCode) {
        return sBookManager.isBookInstalled(bookCode);
    }

//    public static int getBookStatus(BookContainer bookContainer) {
//        return sBookManager.getBookStatus(bookContainer);
//    }

    /**
     * 下载书籍（会下载所有不存在的资源）
     *
     * @param book       要下载的书籍
     * @param isOnlyWifi 是否只在WiFi下下载
     * @param tryRead    是否是试读模式
     */
    public static void download(BookContainer book, boolean tryRead, boolean isOnlyWifi) {
        sBookManager.download(book, tryRead, isOnlyWifi);
    }

    /**
     * 下载书籍（会下载所有不存在的资源）
     *
     * @param book       要下载的书籍
     * @param isOnlyWifi 是否只在WiFi下下载
     */
    public static void download(BookContainer book, boolean isOnlyWifi) {
        sBookManager.download(book, false, isOnlyWifi);
    }

    /**
     * 下载资源
     *
     * @param resource   要下载的资源
     * @param isOnlyWifi 是否只在WiFi下下载
     */
    public static void download(ReaderResource resource, boolean isOnlyWifi) {
        sBookManager.download(resource, isOnlyWifi);
    }

    /**
     * 暂停图书下载
     *
     * @param book 要暂停的书籍
     */
    public static void pause(BookContainer book) {
        sBookManager.pause(book);
    }

    /**
     * 暂停资源下载
     *
     * @param resource 要暂停的资源
     */
    public static void pause(ReaderResource resource) {
        sBookManager.pause(resource);
    }


    public static void pauseAll() {
        sBookManager.pauseAll();
    }

    /**
     * 停止正在下载的任务（如果有），卸载书籍（删除书籍存在于本地的所有资源）
     *
     * @param bookContainer
     */
    public static void uninstallSync(BookContainer bookContainer) {
        sBookManager.uninstallSync(bookContainer);
    }

    public static boolean isDownloading(BookContainer book) {
        return sBookManager.isDownloading(book);
    }

    public static boolean isDownloading(ReaderResource resource) {
        return sBookManager.isDownloading(resource);
    }

    public static boolean isBookUp2Date(String bookCode, String currentVersion, boolean publicResource) {
        return sBookManager.isBookUp2Date(bookCode, currentVersion, publicResource);
    }

}
